/* mesh.h -- mesh handling routines header
**
** Written and Copyright (C) 1994 by Michael J. Gourlay
**
** NO WARRANTEES, EXPRESS OR IMPLIED.
*/

#ifndef _MESH_H__INCLUDED_
#define _MESH_H__INCLUDED_

typedef struct {
  long nx;    /* number of mesh points in the x-direction */
  long ny;    /* number of mesh points in the y-direction */
  double *x;  /* 2D array of x-values */
  double *y;  /* 2D array of y-values */
} MeshT;



void meshInterp(const MeshT *m1P, const MeshT *m2P, double tween_param, MeshT *moP);

void meshReset(MeshT *mP, int mw, int mh);

int meshCheck(const MeshT *mesh1, const MeshT *mesh2);

int meshFunctionalize(MeshT *mP, int mw, int mh);

int meshPointNearest(const MeshT *mP, int px, int py, int *mi, int *mj, int *dx, int *dy);

void meshFree(MeshT *mP, char *proc);

int meshAlloc(MeshT *meshP, char *proc);

int meshAddLine(MeshT *mP, int mi, double mt, int type);

int meshDeleteLine(MeshT *mP, int mi, int type);

int meshLoad(MeshT *meshP, const char *fn);

int meshSave(const MeshT *mP, char *fn);

#endif /* _MESH_H__INCLUDED_ */
