// updates.c

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Scrollbar.h>

#include <stdio.h>

#include "init.h"
#include "updates.h"

extern Colorlib colorlist;

// Updates the position of a scrollbar
int UpdateScrollbar(Widget w, int value) {
	Arg arg;
	union {
		int int_value;
		float float_value;
		} fvalue;

	fvalue.float_value = value/255.0;
	if (fvalue.float_value > 0.97)
		fvalue.float_value = 0.97;
    XtSetArg(arg, XtNtopOfThumb, fvalue.int_value);
    XtSetValues(w, &arg, 1);
	return 0;
}
	
// Updates the value in a text box
int UpdateTextbox(Widget w, int value) {
	char colorname[8];

	sprintf(colorname, "%d", value);
	XtVaSetValues(w, XtNstring, colorname, NULL);

	return 0;
}

// Updates the color of the box so it matches the current RGB values
int UpdateBox(Widget w, int red, int green, int blue, int hack) {
    char colorname[512], color[8];

    if (red + green + blue < 290)
		sprintf(color, "white");
	else
		sprintf(color, "black");

	XtVaSetValues(w, XtVaTypedArg, XtNforeground, XtRString, color, strlen(color),  NULL);

    sprintf(color, "#%02X%02X%02X", red, green, blue);

	if (hack == -2)
   		sprintf(colorname, "#%02X%02X%02X\n  ", red, green, blue);
	else if (hack != -1)
   		sprintf(colorname, "#%02X%02X%02X\n%s", red, green, blue, colorlist.getcolorname(hack));
	else
		sprintf(colorname, "%s", color);

	XtVaSetValues(w, XtVaTypedArg, XtNbackground, XtRString, color, strlen(color), NULL);
	XtVaSetValues(w, XtNlabel, colorname, NULL);

	return(0);
}

