// init.c
// Initialize the widgets other than the popup dialog (in dialog.c)

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/Viewport.h>

#include <stdlib.h>

#include "init.h"
#include "dialog.h"
#include "updates.h"

extern Colorlib colorlist;

// ----------------------------- Global Variables -------------------------------------

Widget box;
Widget scrollbox[3], scrollval[3], scrollbar[3];

// ------------------------------ Update Function -------------------------------------

// Updates all three scrollbars, all three text boxes and the color box
void UpdateAll() {
    for (int i=R; i<=B; i++) {
		UpdateTextbox(scrollval[i], rgb[i]);
	    UpdateScrollbar(scrollbar[i], rgb[i]);
		}
    UpdateBox(box, rgb[R], rgb[G], rgb[B], -1);
}

// --------------------------------------------------------------------------------

// ------------------------------- Callbacks --------------------------------------

// For quit
void Quit(Widget w, XtPointer client_data, XtPointer value) {
	exit(0);
	}

// Callback for the scrollbars
void ScrollbarCallback(Widget w, XtPointer client_data, XtPointer value) {
	int which_bar = (int)client_data;
	int color_value = (int)((*((float *)value))*255);
	int temp = rgb[which_bar] = color_value;

	XawListUnhighlight(list);
	UpdateTextbox(scrollval[which_bar], temp);
	UpdateBox(box, rgb[R], rgb[G], rgb[B], -1);
} 

// Called when the return is pressed in a text box. 
void ReturnAction(Widget w, XEvent *event, String *params, Cardinal *num_params) {
	int color;
	String valuestring;

	if (w == scrollval[R]) 
		color = R;
	else if (w == scrollval[G]) 
		color = G;
	else
		color = B;

   	XtVaGetValues(scrollval[color], XtNstring, &valuestring, NULL);
    rgb[color] = atoi(valuestring);
	
	if (rgb[color] > 255)
		rgb[color] = 255;
	else if (rgb[color] < 0)
		rgb[color] = 0;

    UpdateScrollbar(scrollbar[color], rgb[color]);
    UpdateTextbox(scrollval[color], rgb[color]);
    UpdateBox(box, rgb[R], rgb[G], rgb[B], -1);
    XawListUnhighlight(list);
}

// --------------------------------------------------------------------------------------

// -------------------------------- Misc Functions --------------------------------------

// When you give this function a red, green and blue, it will return
// the index to the descriptor which is nearest the color triplet specified.
int ClosestColor(int *red, int *green, int *blue) {
    int i, index = 0, close = 1000;
    int red_diff, green_diff, blue_diff;

    for (i=0; i<colorlist.cursize(); i++)
        if ((red_diff = abs(*red - colorlist.getcolorvalue(i, R))) < close) 
            if ((green_diff = abs(*green - colorlist.getcolorvalue(i, G))) + red_diff < close) 
                if ((blue_diff = abs(*blue - colorlist.getcolorvalue(i, B))) + green_diff + red_diff < close) {
                    index = i;
                    if (!(close = red_diff + green_diff + blue_diff)) 
                        break;
	                }
	*red =   colorlist.getcolorvalue(index, R);
	*green = colorlist.getcolorvalue(index, G);
	*blue =  colorlist.getcolorvalue(index, B);
	
	return index;
}

// This function will change the current settings to the color in the data
// color which is nearest to it
void ClosestCallback(Widget w, XtPointer client_data, XtPointer in_data) {
    XawListHighlight(list, ClosestColor(&rgb[R], &rgb[G], &rgb[B]));
    UpdateAll();
}

void PickList(Widget w, XtPointer client_data, XtPointer in_data) {
	XawListReturnStruct ret_value = *(XawListReturnStruct*) in_data;

	for (int i=R; i<=B; i++) {
		rgb[i] = colorlist.getcolorvalue(ret_value.list_index, i);
    	UpdateScrollbar(scrollbar[i], rgb[i]);
	    UpdateTextbox(scrollval[i], rgb[i]);
		}

	UpdateBox(box, rgb[R], rgb[G], rgb[B], -1);
}

// Create the rgb[R], rgb[G] and rgb[B] scrollbars, reading in their values
void createscrollbars(Widget w) {
	XtTranslations textFieldTranslations;

    scrollbox[R] = XtVaCreateManagedWidget("redbox", formWidgetClass, w, NULL);
    scrollval[R] = XtVaCreateManagedWidget("redval", asciiTextWidgetClass, scrollbox[R], XtNeditType, XawtextEdit, NULL);
    scrollbar[R] = XtVaCreateManagedWidget("redbar", scrollbarWidgetClass, scrollbox[R], NULL);

    scrollbox[G] = XtVaCreateManagedWidget("greenbox", formWidgetClass, w, NULL);
    scrollval[G] = XtVaCreateManagedWidget("greenval", asciiTextWidgetClass, scrollbox[G], XtNeditType, XawtextEdit, NULL);
    scrollbar[G] = XtVaCreateManagedWidget("greenbar", scrollbarWidgetClass, scrollbox[G], NULL);

    scrollbox[B] = XtVaCreateManagedWidget("bluebox", formWidgetClass, w, NULL);
    scrollval[B] = XtVaCreateManagedWidget("blueval", asciiTextWidgetClass, scrollbox[B], XtNeditType, XawtextEdit, NULL);
    scrollbar[B] = XtVaCreateManagedWidget("bluebar", scrollbarWidgetClass, scrollbox[B], NULL);
   	
    textFieldTranslations = XtParseTranslationTable("<Key>Return: ReturnAction()\n");

	for (int i=R; i<=B; i++) {
		float temp;

		XtVaGetValues(scrollbar[i], XtNtopOfThumb, &temp, NULL);
   		rgb[i] = (int)(temp * 255);
		XtAddCallback(scrollbar[i], XtNjumpProc, ScrollbarCallback, (XtPointer)i);
    	XtOverrideTranslations(scrollval[i], textFieldTranslations);
		}
	}

// Initialize the widgets
void Init(Widget w) {
	Widget u[11], mainpane;

	mainpane = XtVaCreateManagedWidget("toppaned", panedWidgetClass, w, NULL);
	u[0] = XtVaCreateManagedWidget("menuform", formWidgetClass, mainpane, NULL);

	// The "file" menu
	u[1] = XtVaCreateManagedWidget("quit", commandWidgetClass, u[0], NULL);
   
	// The "options" menu
	u[2] = XtVaCreateManagedWidget("optionsbutton", menuButtonWidgetClass, u[0], NULL); 
	u[3] = XtVaCreatePopupShell("optionsmenu", simpleMenuWidgetClass, u[2], NULL);
	u[4] = XtVaCreateManagedWidget("color", smeBSBObjectClass, u[3], NULL);
	u[5] = XtVaCreateManagedWidget("display_match", smeBSBObjectClass, u[3], NULL);

	// The "about" button
	u[6] = XtVaCreateManagedWidget("aboutbutton", menuButtonWidgetClass, u[0], NULL);
	u[7] = XtVaCreatePopupShell("aboutmenu", simpleMenuWidgetClass, u[6], NULL);
	u[8] = XtVaCreateManagedWidget("about", smeBSBObjectClass, u[7], NULL);
	u[9] = XtVaCreateManagedWidget("aboutcopying", smeBSBObjectClass, u[7], NULL);
	
	// Create the scrollbars and text boxes, add their callbacks
	createscrollbars(mainpane);

	// The Box that will hold the color
	box = XtVaCreateManagedWidget("color_label", labelWidgetClass, mainpane, NULL);

	// Create a viewport
	u[10] = XtVaCreateManagedWidget("viewport", viewportWidgetClass, mainpane, XtNallowVert, TRUE, NULL);

	// Create a list widget;
	list = XtVaCreateManagedWidget("color_list", listWidgetClass, u[10], NULL);
	XawListChange(list, colorlist.getcolornamearray(), colorlist.cursize(), -1, TRUE);

	// Create the pop-up dialog.
	CreateDialog(w);

	// Create the about dialog box.
	AboutCreate(w);
	AboutCopyingCreate(w);

 	// Add callbacks for these buttons
	XtAddCallback(u[1], XtNcallback, Quit, 0);
	XtAddCallback(u[4], XtNcallback, ClosestCallback, 0);
	XtAddCallback(u[5], XtNcallback, PopupDialog, w);
	XtAddCallback(u[8], XtNcallback, AboutPopup, w);
	XtAddCallback(u[9], XtNcallback, AboutCopyingPopup, w);
	XtAddCallback(list, XtNcallback, PickList, 0);

	// Finally draw everything right
	UpdateAll();
}

