// dialog.c
// All the routines for poping up a dialog to compare colors

#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Paned.h>

#include <stdio.h>

#include "dialog.h"
#include "init.h"
#include "updates.h"
#include "about.xbm"
#include "copying.xbm"

extern Colorlib colorlist;

int idx;						// Keep track of the list index, if any
XawListReturnStruct *selected;	// Which list element was selected?
Widget pshell;					// The popup shell which the dialog uses
Widget aboutShell;              // The popup shell for the about box
Widget aboutCopyingShell;		// The popup shell for the about copying box
Widget values[7];				// Labels for the old and new RGB's
Widget cbox[2];					// A couple of boxes to display the colors
Pixmap aboutPict;

void DialogDone(Widget, XtPointer, XtPointer);

// Create the pop-up dialog for the color compare function.
void CreateDialog(Widget w) {
    Widget dialog, dialogDone, forms[4];

    pshell =    XtVaCreatePopupShell("pshell", transientShellWidgetClass, w, NULL);
    dialog =    XtVaCreateManagedWidget("dialog", panedWidgetClass, pshell, NULL);
    forms[0] =  XtVaCreateManagedWidget("form0", formWidgetClass, dialog, NULL);
    values[6] = XtVaCreateManagedWidget("value6", labelWidgetClass, dialog, XtNlabel, "name", NULL);
    forms[1] =  XtVaCreateManagedWidget("form1", formWidgetClass, dialog, NULL);
    forms[2] =  XtVaCreateManagedWidget("form2", formWidgetClass, dialog, NULL);

    values[0] = XtVaCreateManagedWidget("value0", labelWidgetClass, forms[0], XtNlabel, "old_red", NULL);
    values[1] = XtVaCreateManagedWidget("value1", labelWidgetClass, forms[0], XtNlabel, "old_green", NULL);
    values[2] = XtVaCreateManagedWidget("value2", labelWidgetClass, forms[0], XtNlabel, "old_blue", NULL);
    values[3] = XtVaCreateManagedWidget("value3", labelWidgetClass, forms[0], XtNlabel, "new_red", NULL);
    values[4] = XtVaCreateManagedWidget("value4", labelWidgetClass, forms[0], XtNlabel, "new_green", NULL);
    values[5] = XtVaCreateManagedWidget("value5", labelWidgetClass, forms[0], XtNlabel, "new_blue", NULL);

    cbox[0] =   XtVaCreateManagedWidget("box0", labelWidgetClass, forms[1], NULL);
    cbox[1] =   XtVaCreateManagedWidget("box1", labelWidgetClass, forms[1], NULL);

    // Add buttons to button form
    dialogDone = XtVaCreateManagedWidget("dialogDone", commandWidgetClass, forms[2], NULL);

    XtAddCallback(dialogDone, XtNcallback, DialogDone, w);
    }

// Popup the dialog and set everything other than it insensitive
void PopupDialog(Widget w, XtPointer client_data, XtPointer call_data) {
	Widget topLevel = (Widget)client_data;
	int i, new_rgb[3];
	char colorstring[10];

	for (i=R; i<=B; i++)
		new_rgb[i] = rgb[i];

	idx = ClosestColor(&new_rgb[R], &new_rgb[G], &new_rgb[B]);

	selected = XawListShowCurrent(list);

	XtSetSensitive(topLevel, FALSE);
    for (i=R; i<=B; i++) {
		sprintf(colorstring, "%4d", rgb[i]);
        XtVaSetValues(values[i], XtNlabel, colorstring, NULL);
		sprintf(colorstring, "%4d", new_rgb[i]);
        XtVaSetValues(values[i+3], XtNlabel, colorstring, NULL);
        }

	UpdateBox(cbox[0], rgb[R], rgb[G], rgb[B], -2);
	XtVaSetValues(values[6], XtNlabel, colorlist.getcolorname(idx), NULL);
	UpdateBox(cbox[1], new_rgb[R], new_rgb[G], new_rgb[B], idx);
	XtPopup(pshell, XtGrabExclusive);
	}

// The dialog is done, so get rid of it and set everything sensitive again
void DialogDone(Widget w, XtPointer client_data, XtPointer call_data) {
    Widget topLevel = (Widget)client_data;

    XtPopdown(pshell);

    XtSetSensitive(topLevel, TRUE);
	if (selected->list_index != XAW_LIST_NONE)
	    XawListHighlight(list, selected->list_index);
    }

// ----------------------------------------------- Stuff for the about box -------------------------------

void AboutDone(Widget w, XtPointer client_data, XtPointer call_data) {
    Widget topLevel = (Widget)client_data;

    XtPopdown(aboutShell);

    XtSetSensitive(topLevel, TRUE);

    if (selected->list_index != XAW_LIST_NONE)
        XawListHighlight(list, selected->list_index);
}

// Popup the dialog and set everything other than it insensitive
void AboutPopup(Widget w, XtPointer client_data, XtPointer call_data) {
    Widget topLevel = (Widget)client_data;

    selected = XawListShowCurrent(list);

    XtSetSensitive(topLevel, FALSE);

    XtPopup(aboutShell, XtGrabExclusive);
    }

void AboutCreate(Widget w)
{
    Widget doneButton;

    aboutShell = XtVaCreatePopupShell("aboutshell", transientShellWidgetClass, w, NULL);

	aboutPict = XCreateBitmapFromData(XtDisplay(w), RootWindowOfScreen(XtScreen(w)), about_bits, about_width, about_height);

	doneButton = XtVaCreateManagedWidget("aboutDoneButton", commandWidgetClass, aboutShell, XtNbitmap, aboutPict, NULL);

    XtAddCallback(doneButton, XtNcallback, AboutDone, w);
}

// About copying stuff

void AboutCopyingDone(Widget w, XtPointer client_data, XtPointer call_data) {
    Widget topLevel = (Widget)client_data;

    XtPopdown(aboutCopyingShell);

    XtSetSensitive(topLevel, TRUE);

    if (selected->list_index != XAW_LIST_NONE)
        XawListHighlight(list, selected->list_index);
}

// Popup the dialog and set everything other than it insensitive
void AboutCopyingPopup(Widget w, XtPointer client_data, XtPointer call_data) {
    Widget topLevel = (Widget)client_data;

    selected = XawListShowCurrent(list);

    XtSetSensitive(topLevel, FALSE);

    XtPopup(aboutCopyingShell, XtGrabExclusive);
    }

void AboutCopyingCreate(Widget w)
{
    Widget aboutCopyingDoneButton;

    aboutCopyingShell = XtVaCreatePopupShell("aboutCopyingshell", transientShellWidgetClass, w, NULL);

    aboutPict = XCreateBitmapFromData(XtDisplay(w), RootWindowOfScreen(XtScreen(w)), copying_bits, copying_width, copying_height);

    aboutCopyingDoneButton = XtVaCreateManagedWidget("aboutCopyingDoneButton", commandWidgetClass, aboutCopyingShell, XtNbitmap, aboutPict, NULL);

    XtAddCallback(aboutCopyingDoneButton, XtNcallback, AboutCopyingDone, w);
}


