.\"
.\" $Id: xping.man,v 1.9 1999/07/10 02:31:55 todd $
.\"
.TH XPING 1 "24 July 1999" "V2.1"
.SH NAME 
xping \- X11 Automated ping tool
.SH SYNOPSIS
.B xping
\fI[-toolkitoption...]\fP 
\fI[options]\fP
.SH DESCRIPTION
.I xping
presents a list of computer systems with a graphic indication of whether or
not each system is alive (that is, responsive to ICMP ECHO_REQUEST datagrams
or ``pings'').  Each system in the list is checked automatically with a
period which can be controlled with command line arguments or X11 resources.

Users may request that the state of a system be checked immediately by
pressing a button.  Any button pressed will remain depressed until the
state of its system can be determined.  This is to indicate that the
state is still uncertain.  When the button is raised, the state is
known.  Multiple buttons can be depressed simultaneously.
.SH OPTIONS
.PP
.I xping
accepts the following command line arguments in addition to the standard
toolkit options:
.TP 8
.I -machines
The list of systems to be displayed.

To display the systems vertically, a simple list should be used:
.nf
	"system1 system2 ... system\fIn\fR"
.fi

To display the systems horizontally, a simple list enclosed in curly braces
should be used:
.nf
	"{ system1 system2 ... system\fIn\fR }"
.fi

To display a two dimensional grid of systems, a list of curly-brace-enclosed 
lists should be used: 
.nf
	"{ upperleft ... upperright } \\
	 {     :             :      } \\
	 { lowerleft ... lowerright }"
.fi

See also the \fBmachines\fR resource.
.TP 8
.I -up path
Bitmap path name for a system in the ``up'' (alive) state.  It may be
in either XBM or XPM format.  The default is a green light.
See also the \fBupBitmap\fR and \fBupBitmapMask\fR resources.
.TP 8
.I -down path
Bitmap path name for a system in the ``down'' (non-alive) state.  It may be
in either XBM or XPM format.  The default is a red light.  See also the
\fBdownBitmap\fR and \fBdownBitmapMask\fR resources.
.TP 8
.I -wasdown path
Bitmap path name for a system in the ``was down'' state.  It may be in either
XBM or XPM format.  The default is a yellow light.  This option is only
meaningful if the -history option is used.  See also the \fBwasDownBitmap\fR
\fBwasDownBitmapMask\fR resources.
.TP 8
.I -history
Activates the ``was down'' state.  Sometimes, it is useful to know that, even
though a system is currently in the ``up'' state, it has been in the ``down''
state recently.  Some user intervention, such as restarting a build, might be
required in such a case.  When this option is used, any system that changes
from the ``down'' state to the ``up'' state will be indicated with a ``was
down'' indication (a yellow light by default).  It remains in that state (or
the ``down'' state if the system goes down again) until its button is pressed
to request information manually.  At that time, assuming the system is up, it
returns to the ``up'' state.  See also the \fBhistoryWarning\fR resource.
.TP 8
.I -left
Display the alive indication to the left of the system name.  xping normally
displays it to the right.  See also the \fBbitmapPosition\fR resource.
.TP 8
.I -irregular
xping normally creates cells of a fixed width large enough to accommodated
the longest system name.  This tends to provide a more pleasing appearance.
If this option is used, xping creates each cell just large enough to
accommodate the system mentioned therein, producing an irregular appearance.
This is probably only desirable for horizontal lists of systems.  See also
the \fBregular\fR resource.
.TP 8
.I -autodepress
When automatically pinging a system, during the interval after the
ECHO_REQUEST datagram is sent and before either the ECHO_RESPONSE datagram is
received or a timeout occurs, the button for the system is depressed as
though the button had been pressed.  This option is mostly useful to
determined how often systems are being pinged automatically.
See also the \fBautoDepress\fR resource.
.TP 8
.I -command string
Specifies an alternate ping command.  Space and tab characters separate the
executable name and arguments unless they are enclosed between matching
single or double quote characters or are preceded by a backslash character.
A backslash character is treated as a quoting character, is itself ignored,
and causes any subsequent character to be treated as an ordinary character.
This is primarily useful for treating space, tab, and single and double
quote, and backslash characters as normal characters, but applies in all
cases.

One of the arguments should be the string ``%s''.  It must be a distinct
argument.  Each time the command is executed, this argument will be replaced
with the name of the system to be pinged.

Note that the characters treated specially by xping are also treated
specially by most shells.  Care must be taken to ensure that the correct
string is passed to xping.

See also the \fBpingCommand\fR resource.
.TP 8
.I -button2 string
Specify a command to be executed when the middle mouse button is pressed for
a button instead of the left mouse button.  The syntax and interpretation of
the string are the same as for the -command option, as is the requirement
that one of the command string's arguments be the string ``%s''.  See also
the \fBbutton2Command\fR resource.
.TP 8
.I -button3 string
Specify a command to be executed when the right mouse button is pressed for a
button instead of the left mouse button.  The syntax and interpretation of
the string are the same as for the -command option, as is the requirement
that one of the command string's arguments be the string ``%s''.  See also
the \fBbutton3Command\fR resource.
.TP 8
.I -delay n
Specifies the minimum time in milliseconds after a system has been pinged
before it will be pinged again automatically.  It defaults to 60 seconds.
The time between ping attempts may be longer than specified if the
-maxparallel value is small (such as the default) and the number of systems
being monitored is large.  Of course, a user may always request that a system
be pinged immediately by pressing its button.  See also the \fBdelay\fR
resource.
.TP 8
.I -retries n
Species the number of ping retries before a system is considered to be
``down''.  This is useful on unreliable networks where ICMP datagrams are
frequently lost.  By default, xping expects the network to be reliable, so
this value is 0.  See also the \fBnumRetries\fR resource.
.TP 8
.I -maxparallel n
Specifies the maximum number of ping attempts that can be active
simultaneously.  It may cause longer delays between ping attempts than the
time specified by the -delay option.  This number will never be exceeded by
an automatic ping, but may be exceeded by pressing a button.  The default is
1.  This is designed to keep the network load reasonably balanced.  However,
if the number of systems being monitored is large and/or many systems are
``down'' then long periods of time may elapse between any single system being
checked twice.  In such cases, xping will always check the system whose state
is most ``out-of-date'' first, but it may be desirable to increase the
-maxparallel value.  See also the \fBmaxParallel\fR resource.
.SH RESOURCES
xping understands all of the core X Toolkit resource names and classes as
well as the following resources in name/class (type) format:
.\".in +1in
.TP 8
.B "machines/Machines (String)"
List of systems.  See -machines.
.TP 8
.B "upBitmap/NormalBitmap (String)"
Bitmap path name for ``up'' state.  See -up.
.TP 8
.B "upBitmapMask/NormalBitmapMask (String)"
Bitmap shape mask path name for ``up'' state.  It need not be specified if
the \fBupBitmap/NormalBitmap\fR resource specifies a file in the XPM format.
See -up.
.TP 8
.B "downBitmap/AlertBitmap (String)"
Bitmap path name for ``down'' state.  See -down.
.TP 8
.B "downBitmapMask/AlertBitmapMask (String)"
Bitmap shape mask path name for ``down'' state.  It need not be specified if
the \fBdownBitmap/AlertBitmap\fR resource specifies a file in the XPM format.
See -down.
.TP 8
.B "wasDownBitmap/WarningBitmap (String)"
Bitmap path name for ``was down'' state.  See -wasdown.
.TP 8
.B "wasDownBitmapMask/WarningBitmapMask (String)"
Bitmap shape mask path name for ``was down'' state.  It need not be specified
if the \fBwasDownBitmap/WarningBitmap\fR resource specifies a file in the XPM
format.  See -wasdown.
.TP 8
.B "historyWarning/HistoryWarning (Boolean)"
Specifies whether or not the ``was down'' state is active.  See -history.
.TP 8
.B "bitmapPosition/BitmapPosition (String)"
Either the string ``left'' or ''right'', indicating on which side of the
system name the state indication should appear.  Defaults to right.  See
-left.
.TP 8
.B "regular/Regular (Boolean)"
Specifies whether or not all system cells should have constant width.
Defaults to true.  See -irregular.
.TP 8
.B "autoDepress/AutoDepress (Boolean)"
Specifies whether or not buttons should be depressed when their systems are
being pinged automatically.  See -autodepress.
.TP 8
.B "pingCommand/PingCommand (String)"
Alternate ``ping'' command.  See -command.
.TP 8
.B "button2Command/ButtonCommand (String)"
Command to be executed when the middle mouse button is pressed.  See
-button2.
.TP 8
.B "button3Command/ButtonCommand (String)"
Command to be executed when the right mouse button is pressed.  See -button3.
.TP 8
.B "delay/Delay (Cardinal)"
Minimum delay in milliseconds after a ping of a system before it is pinged
again automatically.  Defaults to 60 seconds.  See -delay.
.TP 8
.B "numRetries/NumRetries (Cardinal)"
Number of ping retries before a system is considered ``down''.  See -retries.
.TP 8
.B "maxParallel/MaxParallel (Cardinal)"
Specifies the maximum number of pings that can be active simultaneously.  See
-maxparallel.

.PP
In addition, xping's widgets (including the application itself) also accept
the resources defined by \fIXaw-XPM\fR.  See below for a description of
xping's widgets.  In particular, the following resources are supported:
.TP 8
.B "pixmapName/BGPixmap (String)"
Specifies the path name of the XPM pixmap for the ``normal'' background.
.TP 8
.B "setPixmap/BGPixmap (String)"
Specifies the path name of the XPM pixmap for the background for the ``set''
(depressed) state.
.TP 8
.B "hlPixmap/BGPixmap (String)"
Specifies the path name of the XPM pixmap for the background for the
highlight state (when the cursor is over a button).
.TP 8
.B "pixDir/PixDir (String)"
Specifies the directory to be searched with loading pixmaps.
.TP 8
.B "notifySound/Sound (String)"
Specifies the path name of an .au file to play when a button has been
pressed.
.TP 8
.B "hlSound/Sound (String)"
Specifies the path name of an .au file to play when cursor is over a button.
.TP 8
.B "drawTextBorder/drawTextBorder (Boolean)"
Specifies whether or not to draw a 1 pixel border around a button.
.TP 8
.B "shaped/Shaped (Boolean)"
Specifies whether or not a button has a non-rectangular shape.
.TP 8
.B "shapeMask/shapeMask (String)"
If the shaped resource is true, specifies the path name of the XPM pixmap
which determines the shape.  If not specified, the pixmapName resource
determines the shape.
.TP 8
.B "ridgeShadow/RidgeShadow (Boolean)"
Specifies whether or not to display a 3d button (as a ridge or groove
depending on the invertBorder value).
.TP 8
.B "armPixel/ArmPixel (Color)"
Specifies background color for a depressed button.
.SH WIDGETS
It is useful to know the hierarchy of widgets in order to specify very fine
grain resources.  In the following diagram, indentation indicates
hierarchical structure.  Each line contains the widget class name followed by
the widget instance name (or a description thereof).

.nf
	XPing  xping
		Box  box
			Box  box\fIn\fR (one per row, from 0)
				BoxCommand  \fIsystem-name\fR	
					TransparentLabel  label
					Core  light
				 -or-
				Simple  "" (empty cell)
.fi
.SH BUGS
Ultimately, the state of systems indicated by xping is only as reliable as
the information reported by ping(1).
.PP
By default, xping requires a minimum of 24 free color cells (or 35 with the
-history option) to load the pixmaps for the lights.  The pixmaps and
therefore the minimum number of colors can be overridden through options or
resources.
.SH INCOMPATIBILITIES
The ability to indicate busy systems with an additional pixmap, controlled by
the \fBbusyEnable/BusyEnable\fR and \fBidleCommand/IdleCommand\fR resources,
was removed after version 1.0.  It was never used because of the difficulty
in developing a mechanism to determine if a foreign system was busy, quickly.
.PP
The \fBpingDelay/PingDelay\fR resource was replaced after version 1.0 by the
more reliable \fBdelay/Delay\fR resource.
.PP
The \fBnoiseEnable/NoiseEnable\fR, \fBnoiseIconPassive/NormalBitmap\fR, and
\fBnoiseIconActive/AlertBitmap\fR resources were removed after version 1.0
because they became meaningless.  xping no longer has periods of time when
pressed buttons are ignored.
.PP
The \fBseparators/Separators\fR resource was removed after version 1.0
because it was superseded by various other Xt and Athena Widget Set
resources.
.SH "SEE ALSO"
ping(1)
.SH ACKNOWLEDGMENTS
Many people from the X Consortium and DEC for their work on Xt and the Athena
Widget Set.
.br
Kaleb S. Keithley for the Xaw3d widget set.
.br
Ben Buxton for the Xaw-XPM extensions to Xaw3d.
.br
Jim Burmeister for the original Tcl/Tk prototype of xping.
.SH COPYRIGHT
Copyright 1999 by Todd Allen.  All Rights Reserved.  Permission to use, copy,
modify, distribute, and sell this software and its documentation for any
purpose is hereby granted without fee, provided that the above copyright
notice appear in all copies and that both the copyright notice and this
permission notice appear in supporting documentation.
.PP
No representations are made about the suitability of this software for any
purpose.  It is provided ``as is'' without express or implied warranty,
including but not limited to the warranties of merchantability, fitness for a
particular purpose, and noninfringement.  In no event shall Todd Allen be
liable for any claim, damages, or other liability, whether in action of
contract, tort, or otherwise, arising from, out of, or in connection with
this software.
.PP
Portions of this software are Copyright by other parties:
.PP
Copyright (c) 1987, 1988, 1994 X Consortium.  Permission is hereby granted,
free of charge, to any person obtaining a copy of this software and
associated documentation files (the "Software"), to deal in the Software
without restriction, including without limitation the rights to use, copy,
modify, merge, publish, distribute, sublicense, and/or sell copies of the
Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial portions of
the Software.
.PP
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard,
Massachusetts.  All Rights Reserved.  Permission to use, copy, modify, and
distribute this software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright notice appear in all
copies and that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Digital not be used in
advertising or publicity pertaining to distribution of the software without
specific, written prior permission.
.PP
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard,
Massachusetts, and the Massachusetts Institute of Technology, Cambridge,
Massachusetts, and Copyright 1992 by Kaleb Keithley.  Permission to use,
copy, modify, and distribute this software and its documentation for any
purpose and without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and this
permission notice appear in supporting documentation, and that the names of
Digital, MIT, or Kaleb Keithley not be used in advertising or publicity
pertaining to distribution of the software without specific, written prior
permission.
.SH AUTHOR
Todd Allen
.br
Email: todd.allen@ibm.net or todd.allen@mail.ccur.com
