/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "lay_data.h"
#include "xippktcut.h"

t_pkt				*xip_cut_pkt = NULL;

/* initializes internal cut buffer to a one byte data packet.
   Returns 0 if OK. Might return various error messages. */
t_status			xippktcut_init(VOID_DECL)
{
  t_status			status;
  
  if ((xip_cut_pkt = pkt_new(1,
			     lay_data_msg,
			     XIP_ALLOC_PROC,
			     XIP_FREE_PROC,
			     &status)) == NULL)
    return (status);
  return (0);
}

/* destroys internal cut buffer */
VOID_FUNC			xippktcut_destroy(VOID_DECL)
{
  pkt_delete(xip_cut_pkt,XIP_FREE_PROC);
}

/* cuts the specified packet to internal cut buffer.
   Returns 0 if OK. Might return various errors. */
t_status			xip_pkt_cut(pkt)
t_pkt				*pkt;
{
  char				*nbuf;
  t_status			status;

  assert(xip_cut_pkt);
  if ((nbuf = XIP_ALLOC_PROC(pkt->len * sizeof (char),
			     "xippktcut",
			     "xip_pkt_cut:buf",
			     &status)) == NULL)
    return (status);
  bcopy(pkt->buf,nbuf,pkt->len);
  XIP_FREE_PROC(xip_cut_pkt->buf,
		"xippktcut",
		"*:buf");
  xip_cut_pkt->buf = nbuf;
  xip_cut_pkt->len = pkt->len;
  xip_cut_pkt->netlen = pkt->netlen;
  return (0);
}

/* pastes internal cut buffer to specified packet.
   Returns 0 if OK. Might return various errors */
t_status			xip_pkt_paste(pkt)
t_pkt				*pkt;
{
  char				*nbuf;
  t_status			status;

  assert(xip_cut_pkt);
  if ((nbuf = XIP_ALLOC_PROC((pkt->len + xip_cut_pkt->len) * sizeof (char),
			     "xippktcut",
			     "xip_pkt_paste:buf",
			     &status)) == NULL)
    return (status);
  bcopy(pkt->buf,nbuf,pkt->len);
  bcopy(xip_cut_pkt->buf,nbuf + pkt->len,xip_cut_pkt->len);
  XIP_FREE_PROC(pkt->buf,
		"xippktcut",
		"*:buf");
  pkt->buf = nbuf;
  pkt->len = pkt->len + xip_cut_pkt->len;
  pkt->netlen = pkt->netlen + xip_cut_pkt->netlen;
  return (0);
}
