/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/uio.h>
#include <netinet/in.h>
#include <fcntl.h>
#include "lay_ether.h"
#include "lay_arp.h"
#include "lay_ip.h"
#include "lay_data.h"
#include "xippkt.h"
#include "xipcf.h"

t_ether_addr		sendalpha_ether_dst = {0x00,0x00,0xf8,0x00,0xb3,0x96};
char			sendalpha_ifname[STR_BUFSIZ] = {'t','u','0',0};

/* opens named interface.
   Calls directly pfopen(2).
   Returns a file descriptor or a negative status meaning that something has 
   failed. */
int			ether_open(ifname)
char			*ifname;	/* Interface name */
{
  return (pfopen(ifname,O_WRONLY));
}

/* close file descriptor */
VOID_FUNC		ether_close(fd)
int			fd;
{
  close(fd);
}

/* writes out an ethernet packet.
   Returns: See writev(2). 
   
   Warning: if dhost is incorrect (see etheraddr_from_str(3)) it
   might cause panic! */
int			ether_write(fd,dhost,type,databuf,datalen)
int			fd;		/* Pf file descriptor */
t_ether_addr		*dhost;		/* Destination ethernet address */
int			type;		/* Host format of ethernet type */
char			*databuf;	/* Data buffer e.g starting
					   from ip header */
int			datalen;	/* Data length */
{
  t_ether		ether;
  struct iovec		iov[2];

  assert(datalen != 0);
  FBCOPY(dhost,&(ether.dhost),sizeof (t_ether_addr));
  ether.type = htons(type);
  iov[0].iov_base = (caddr_t)(&ether);
  iov[0].iov_len = sizeof (ether);
  iov[1].iov_base = databuf;;
  iov[1].iov_len = datalen;
  return (writev(fd,iov,2));
}

int				ether_fd = -1;

/* is a t_xip_method_proc.
   Sends out an ethernet packet.
   Is able to send "ether" pkts or either "ip" or "arp" in using
   global sendalpha_ether_dst.
   Returns 0 if OK. -ERR_NOMETHOD if packet is not ether, ip or arp.
   Might return various errors */
t_status			method_send(xmd,args)
t_xip_method_data		*xmd;
t_vec				*args;
{
  t_ether_addr			dhost;
  int				type;
  t_pkt				sub_pkt;  
  t_pkt				*sent_pkt;
  t_status			status;
  t_in_addr			dst;
  char				buf[STR_BUFSIZ];

  if (xmd->xp->pkt->mp == lay_ether_msg)
    {
      buf[0] = 0;
      if ((status = pkt_get_field_to_str(xmd->xp->pkt,
					 "ether[0].dhost",
					 buf,
					 sizeof (buf))) < 0)
	return (status);
      if ((status = etheraddr_from_str(&dhost,
				       buf)) < 0)
	return (status);
      buf[0] = 0;
      if ((status = pkt_get_field_to_str(xmd->xp->pkt,
					 "ether[0].type",
					 buf,
					 sizeof (buf))) < 0)
	return (status);
      type = atoi(buf);
      if ((status = pkt_sub(xmd->xp->pkt,&sub_pkt)) < 0)
	return (status);
      sent_pkt = &sub_pkt;
    }
  else
    {
      if (xmd->xp->pkt->mp == lay_ip_msg)
	{
	  type = ETHERTYPE_IP;
	  buf[0] = 0;
	  if ((status = pkt_get_field_to_str(xmd->xp->pkt,
					     "ip[0].dst",
					     buf,
					     sizeof (buf))) < 0)
	    return (status);
	}
      else
	if (xmd->xp->pkt->mp == lay_arp_msg)
	  {
	    type = ETHERTYPE_ARP;
	    buf[0] = 0;
	    if ((status = pkt_get_field_to_str(xmd->xp->pkt,
					       "arpethip[0].tpa",
					       buf,
					       sizeof (buf))) < 0)
	      return (status);
	  }
	else
	  return (-ERR_NOMETHOD);
      sent_pkt = xmd->xp->pkt;
      bcopy((char *)(&sendalpha_ether_dst),
	    (char *)(&dhost),
	    sizeof (t_ether_addr));
    }
  if (ether_write(ether_fd,
		  &dhost,
		  type,
		  sent_pkt->buf,
		  sent_pkt->len) < 0)
    return (-ERR_WRITE);
  return (0);
}

/* initializes the "sendalpha" plugin.
   Note: registers a new packet bar title and a new method.
   Returns 0. If it is not able to open sendalpha_ifname (interface), it
   prints out an error message. */
t_status		xip_plugin_init(VOID_DECL)
{
  t_assoc		assoc;
  t_status		status;

  if ((ether_fd = ether_open(sendalpha_ifname)) < 0)
    {
      err_print(ERR_OPEN,sendalpha_ifname);
      return (0);
    }
  assoc.left = "send";
  assoc.right = method_send;
  if ((status = method_add(&assoc)) < 0)
    return (status);
  assoc.left = "Send";
  assoc.right = "send()";
  if ((status = pktbar_add(&assoc)) < 0)
    return (status);
  return (0);
}
