/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "typ_seqack.h"
#include "lay_tcp.h"

typedef struct			s_seq_ack
{
  t_tcp_seq			seq;
  t_tcp_seq			ack;
} t_seq_ack;

typedef struct			s_seq_ack_key
{
  t_in_addr			src;
  t_in_addr			dst;
  t_u32				port;
} t_seq_ack_key;

typedef struct			s_seq_ack_hash
{
  struct s_seq_ack_hash		*next;
  t_seq_ack_key			key;
  t_tcp_seq			seq;
  t_tcp_seq			ack;
} t_seq_ack_hash;

#define SEQ_ACK_HASHSIZE	919

t_seq_ack_hash			seq_ack_hash[SEQ_ACK_HASHSIZE];

/* is a t_msg_proc.
   It manages tcp sequence number ala tcpdump(8).
   It requires a fullfilled t_seq_ack_data structure as ed->data.
   Returns 0 if OK. Might return various errors. */
t_status			typ_seqack_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  t_status			status;

  switch (msg)
    {
      TYP_CLASS_GENERIC;
      TYP_NAME_GENERIC("seqack");
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	t_seq_ack		*sa;
	t_tcp_seq		seq;
	t_tcp_seq		ack;
	
	if (ed->b.len < sizeof (t_seq_ack))
	  return (-ERR_TRUNC);
	sa = (t_seq_ack *)(ed->b.buf);
	seq = safe_ntohl(&sa->seq); /* ALIGNMENT */
	ack = safe_ntohl(&sa->ack); /* ALIGNMENT */
	if (ed->data)
	  {
	    t_seq_ack_data	*sad;
	    t_seq_ack_key	sak;
	    t_boolean		rev;
	    t_seq_ack_hash	*sah;
	    
	    sad = (t_seq_ack_data *)(ed->data);
	    if (sad->sport < sad->dport ||
		(sad->sport == sad->dport &&
		 sad->src.s_addr < sad->dst.s_addr)) 
	      {
		FBCOPY(&sad->src,&sak.src,sizeof (sak.src));
		FBCOPY(&sad->dst,&sak.dst,sizeof (sak.dst));
		sak.port = sad->sport << 16 | sad->dport;
		rev = FALSE;
	      }
	    else 
	      {
		FBCOPY(&sad->dst,&sak.src,sizeof (sak.src));
		FBCOPY(&sad->src,&sak.dst,sizeof (sak.dst));
		sak.port = sad->dport << 16 | sad->sport;
		rev = TRUE;
	      }
	    for (sah = &seq_ack_hash[sak.port % SEQ_ACK_HASHSIZE];
		 sah->next;
		 sah = sah->next)
	      if (!FBCMP(&sak,&sah->key,sizeof (sah->key)))
		break;
	    if (sah->next)
	      {
		if (sah->ack == ack &&
		    sah->seq == seq)
		  goto unchanged;
		if (sad->flags & TCP_SYN)
		  goto new;
		if (rev)
		  {
		    seq -= sah->ack;
		    ack -= sah->seq;
		  }
		else
		  {
		    seq -= sah->seq;
		    ack -= sah->ack;
		  }
	      }
	    else
	      {
	      new:
		if (sah->next == NULL) 
		  {
		    if ((sah->next = LAYER_ALLOC_PROC(sizeof (t_seq_ack_hash),
						     "layer",
						     "typ_seqack_msg:ptr",
						     &status)) == NULL)
		      return (status);
		    FBZERO(sah->next,sizeof (t_seq_ack_hash));
		  }
		FBCOPY(&sak,&sah->key,sizeof (t_seq_ack_key));
		if (rev)
		  {
		    sah->ack = seq;
		    sah->seq = ack - 1;
		  }
		else
		  {
		    sah->seq = seq;
		    sah->ack = ack - 1;
		  }
	      }
	  unchanged:
	    if (sad->seq_wanted)
	      return (str_cat_fmt_va(bs->str,
				     bs->max_len,
				     "%u:%u(%d)",
				     seq,
				     seq + sad->datalen,
				     sad->datalen));
	    else
	      return (ulong_to_str((unsigned long)ack,
				   layer_base,
				   bs->str,
				   bs->max_len));
	  }
	return (0);
      }
    case TYP_INSERT:
      {
	TYP_INSERT_ARGS(ed,str);
	
	return (-ERR_NI);
      }
    case TYP_OFF:
      {
	TYP_OFF_ARGS(ed,off);
	
	(*off) = sizeof (t_seq_ack);
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}
