/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "a.h"
#ifdef HAVE_RPC_NETDB_H
# include <rpc/netdb.h>
#else
# include <netdb.h>
#endif
#include "layer.h"
#include "typ_msg.h"
#include "typ_rpc.h"
#include "typ_32.h"

/* converts a string into a rpc number.
   It uses getservbyname(3) and reverts to atoi(3) if not found.
   Returns the rpc number */
int			rpc_from_str(str,resolve)
char			*str;		/* A service name or a number */
t_boolean		resolve;	/* If FALSE,bypasses getrpcbyname(3)*/
{
  if (resolve)
    {
      struct rpcent	*rpcentry;

      setrpcent(0);
      if (rpcentry = getrpcbyname(str))
	{
	  int		rpc;
	  
	  rpc = rpcentry->r_number;

	  endrpcent();
	  return (rpc);
	}
      endrpcent();
    }
  return (atoi(str));
}

/* converts-and-catenates a rpc number to a bridled string.
   It uses getservbyrpc(3) and reverts to long_to_str(3) if not found.
   Returns 0 if OK, might return various errors */
t_status		rpc_to_str(rpc,str,max_len,resolve)
int			rpc;		/* Rpc number */
char			*str;		/* Valid string */
int			max_len;	/* Maximum length */
t_boolean		resolve;      /* If FALSE, bypasses getrpcbynumber(3)*/
{
  if (resolve)
    {
      struct rpcent	*rpcentry;

      setrpcent(0);
      if (rpcentry = getrpcbynumber(rpc))
	{
	  char		*name;
	  
	  name = rpcentry->r_name;
	  endrpcent();
	  return (str_cat_str(str,max_len,name));
	}
      endrpcent();
    }
  return (ulong_to_str((unsigned long)rpc,
		       layer_base,
		       str,
		       max_len));
}

/* is a t_msg_proc.
   Manages rpc numbers. */
t_status		typ_rpc_resolved_msg(msg,arg1,arg2)
t_msg			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  t_status		status;

  switch (msg)
    {
      TYP_CLASS_GENERIC;
      TYP_NAME_GENERIC("rpc_resolved");
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	t_u32		u32;
	t_status	status;
	
	if (ed->b.len < sizeof (t_u32))
	  return (-ERR_TRUNC);
	FBCOPY(ed->b.buf,&u32,sizeof (t_u32));
	u32 = UNSAFE_NTOHL(u32);
	return (rpc_to_str(u32,
			   bs->str,
			   bs->max_len,
			   (t_boolean)layer_resolve));
      }
    case TYP_INSERT:
      {
	TYP_INSERT_ARGS(ed,str);
	t_u32		u32;
	t_status	status;	
	int		rpc;
	
	if (ed->b.len < sizeof (u32))
	  return (-ERR_TRUNC);
	if ((rpc = rpc_from_str(str,
				TRUE)) < 0)
	  return (rpc);
	u32 = rpc;
#ifdef NOTDEF
	u32 = UNSAFE_HTONL(u32);
#endif
	FBCOPY(&u32,ed->b.buf,sizeof (u32));
	return (0);
      }
    case TYP_GET_CHOICES:
      {
	TYP_GET_CHOICES_ARGS(ed,vec_str);
	struct rpcent	*rpcentry;

	setrpcent(0);
	while (rpcentry = getrpcent())
	  {
	    if ((status = vec_str_add(vec_str,
				      rpcentry->r_name)) < 0)
	      return (status);
	  }
	endrpcent();
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}	
