/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "layer.h"
#include "typ_msg.h"
#include "typ_icmpcode.h"
#include "layer.h"

t_assoc			icmp_unreachable_assocs[] = 
{
  {"net_unreachable",		(VOID_PTR)0},
  {"host_unreachable",		(VOID_PTR)1},
  {"prot_unreachable",		(VOID_PTR)2},
  {"port_unreachable",		(VOID_PTR)3},
  {"frag_needed_but_no_df",	(VOID_PTR)4},
  {"src_route_failed",		(VOID_PTR)5},
  {"dst_net_unknown",		(VOID_PTR)6},
  {"dst_host_unknown",		(VOID_PTR)7},
  {"src_host_isolated",		(VOID_PTR)8},
  {"dst_net_prohibited",	(VOID_PTR)9},
  {"dst_host_prohibited",	(VOID_PTR)10},
  {"net_unreachable_for_tos",	(VOID_PTR)11},
  {"host_unreachable_for_tos",	(VOID_PTR)12},
  {"comm_prohibited_by_filtering",(VOID_PTR)13},
  {"host_precedence_violation",	(VOID_PTR)14},
  {"precedence_cutoff_in_effect",(VOID_PTR)15},
  {NULL,			NULL},
};

t_assoc			icmp_redirect_assocs[] = 
{
  {"for_net",			(VOID_PTR)0},
  {"for_host",			(VOID_PTR)1},
  {"for_tos_and_net",		(VOID_PTR)2},
  {"for_tos_and_host",		(VOID_PTR)3},
  {NULL,			NULL},
};

t_assoc			icmp_timex_assocs[] =
{
  {"during_transit",	(VOID_PTR)0},
  {"during_reassembly",	(VOID_PTR)1},
  {NULL,		NULL},
};

t_assoc			icmp_paramprob_assocs[] = 
{
  {"ip_header_bad",	(VOID_PTR)0},
  {"required_opt_missing",(VOID_PTR)1},
  {NULL,		NULL},
};

t_assoc			icmpcode_assocs[] =
{
  {(VOID_PTR)3,		icmp_unreachable_assocs},
  {(VOID_PTR)5,		icmp_redirect_assocs},
  {(VOID_PTR)11,	icmp_timex_assocs},
  {(VOID_PTR)12,	icmp_paramprob_assocs}
};

t_assoc			*icmpcode_get_assocs_from_type(type)
int			type;
{
  int			i;

  i = 0;
  while (i < ARRAY_COUNT(icmpcode_assocs))
    {
      if ((int)(icmpcode_assocs[i].left) == type)
	return ((t_assoc *)(icmpcode_assocs[i].right));
      i++;
    }
  return (NULL);
}

t_status		icmpcode_to_str(buf,len,str,max_len)
char			*buf;
int			len;
char			*str;
int			max_len;
{
  t_assoc		*assocs;

  if (len < 2)
    return (-ERR_TRUNC);
  if ((assocs = icmpcode_get_assocs_from_type((t_u32)(t_u8)(buf[0]))) == NULL)
    return (ulong_to_str((unsigned long)(t_u8)(buf[1]),
			 layer_base,
			 str,
			 max_len));
  else
    {
      t_assoc		*assoc;

      if ((assoc = assoc_str_int_from_right(assocs,
					    (t_u32)(t_u8)buf[1])) == NULL)
	return (ulong_to_str((unsigned long)(t_u8)(buf[1]),
			     layer_base,
			     str,
			     max_len));
      else
	return (str_cat_str(str,
			    max_len,
			    assoc->left));
    }
}

t_status		icmpcode_from_str(buf,len,str)
char			*buf;
int			len;
char			*str;
{
  t_assoc		*assocs;

  if (len < 2)
    return (-ERR_TRUNC);
  if ((assocs = icmpcode_get_assocs_from_type((t_u32)(t_u8)(buf[0]))) == NULL)
    return (-ERR_UNRESOLVABLE);
  else
    {
      t_assoc		*assoc;

      if ((assoc = assoc_str_ptr_from_left(assocs,str)) == NULL)
	return (-ERR_UNRESOLVABLE);
      else
	{
	  buf[1] = (t_u8)(t_u32)(assoc->right);
	  return (0);
	}
    }
}

t_status		icmpcode_get_choices(buf,len,vec_str)
char			*buf;
int			len;
t_vec			*vec_str;
{
  t_assoc		*assocs;

  if (len < 2)
    return (-ERR_TRUNC);
  if ((assocs = icmpcode_get_assocs_from_type((t_u32)(t_u8)(buf[0]))) == NULL)
    return (-ERR_NOCHOICE);
  else
    {
      t_assoc		*assoc;

      assoc = assocs;
      while (assoc->left)
	{
	  t_status	status;

	  if ((status = vec_str_add(vec_str,
				    assoc->left)) < 0)
	    return (status);
	  assoc++;
	}
      return (0);
    }
}

/* is a t_msg_proc.
   It manages icmp codes. Note that it depends of the icmp type and you
   must provide it the icmp type offset directly */
t_status		typ_icmpcodeagainsttype_msg(msg,arg1,arg2)
t_msg			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  t_status		status;

  switch (msg)
    {
      TYP_CLASS_GENERIC;
      TYP_NAME_GENERIC("icmpcodeagainsttype");
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	
	return (icmpcode_to_str(ed->b.buf,
				ed->b.len,
				bs->str,
				bs->max_len));
      }
    case TYP_INSERT:
      {
	TYP_INSERT_ARGS(ed,str);
	
	return (icmpcode_from_str(ed->b.buf,
				  ed->b.len,
				  str));
      }
    case TYP_GET_CHOICES:
      {
	TYP_GET_CHOICES_ARGS(ed,vec_str);
	
	return (icmpcode_get_choices(ed->b.buf,
				     ed->b.len,
				     vec_str));
      }
    }
  return (-ERR_NOMETHOD);
}	
