/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "layer.h"
#include "typ_msg.h"
#include "typ_dnsrdata.h"
#include "typ_16.h"

/* is a t_msg_proc.
   Manages memory zones in the form of |len (2 bytes)|c1|c2|...|clen| as
   used mainly in dns response data. It can encode data from a length of
   zero up to 65535. */
t_status		typ_dnsrdata_msg(msg,arg1,arg2)
t_msg			msg;
VOID_PTR		arg1;
VOID_PTR		arg2;
{
  switch (msg)
    {
      TYP_CLASS_GENERIC;
      TYP_NAME_GENERIC("dnsrdata");
    case TYP_EXTRACT:
      {
	TYP_EXTRACT_ARGS(ed,bs);
	t_u16		len;

	if (ed->b.len < 2)
	  return (-ERR_TRUNC);
	FBCOPY(ed->b.buf,&len,sizeof (len));
	len = UNSAFE_NTOHS(len);
	if (ed->b.len < (2 + len))
	  return (-ERR_TRUNC);
	return (buf_to_xdata_str(ed->b.buf + 2,
				 len,
				 65535 + 1, /* INFINITY */
				 "",
				 " ",
				 bs->str,
				 bs->max_len));
      }
    case TYP_INSERT:
      {
	TYP_INSERT_ARGS(ed,str);
	t_status	status;	
	int		ilen;
	char		buf[BUFSIZ];
	t_u16		len;

	if ((status = xdata_to_buf(str,
				   buf,
				   &ilen,
				   sizeof (buf))) < 0)
	  return (status);
	if (ilen > 65535)
	  return (-ERR_TOOBIG);
	if (ed->b.len < (ilen + 2))
	  return (-ERR_TRUNC);
	len = UNSAFE_HTONS((t_u16)ilen);
	FBCOPY(&len,ed->b.buf,sizeof (len));
	bcopy(buf,ed->b.buf + 2,ilen);
	return (0);
      }
    case TYP_OFF:
      {
	TYP_OFF_ARGS(ed,off);
	t_u16		len;

	if (ed->b.len < 2)
	  return (-ERR_TRUNC);
	FBCOPY(ed->b.buf,&len,sizeof (len));
	len = UNSAFE_NTOHS(len);
	(*off) = len + 2;
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}	
