/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "layer.h"

/* initializes lays and typs provided by liblayer.
   Returns 0 if OK, might return various errors and might print
   error messages using err_print(3). */
t_status			layer_init(VOID_DECL)
{
  t_status			status;

  if ((status = lay_data_init()) < 0)
    {
      err_print(-status,"lay_data_init");
      return (status);
    }
  if ((status = lay_udp_init()) < 0)
    {
      err_print(-status,"lay_udp_init");
      return (status);
    }
  if ((status = lay_dict_init()) < 0)
    {
      err_print(-status,"lay_dict_init");
      return (status);
    }
  return (0);
}

/* destroys lays and typs provided by liblayer. */
VOID_FUNC			layer_destroy(VOID_DECL)
{
  lay_dict_destroy();
  lay_udp_destroy();
  lay_data_destroy();
}

t_32				layer_resolve = TRUE;
t_32				layer_base = 10;
t_32				layer_verb_level = 0;

t_mask_def			layer_verb_level_mask_defs[] = 
{
  {"lay_msg",			VERB_LAY_MSG},
  {"typ_msg",			VERB_TYP_MSG},
  {"layer_init",		VERB_LAYER_INIT},
  {"miscinet",			VERB_MISCINET},
  {"pkt_sav",			VERB_PKT_SAV},
  {"all",			~0L},
  {NULL,			0}
};

#ifdef DEBUG
/* initializes the layer debug env. 
   This is a debug function */
VOID_FUNC		layer_debug_init(VOID_DECL)
{
  char			*str;
  t_mask		mask;

  if (str = getenv("LAYER_VERB_LEVEL"))
    {
      t_vec		*vec;
      t_status		status;

      vec = LAYER_VEC_NEW(&status);
      assert(vec);
      if ((status = vec_str_split(vec,str,'|')) < 0)
	{
	  err_print(-status,"layer_debug_init");
	  abort();
	}
      if ((status = mask_from_vec_str(layer_verb_level_mask_defs,
				      vec,
				      &mask)) < 0)
	{
	  err_print(-status,"layer_debug_init");
	  abort();
	}
      layer_verb_level = (t_32)mask;
      vec_str_delete(vec);
    }
}
#endif
