/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <time.h>
#include "layer.h"
#include "lay_data.h"
#include "lay_ipopt.h"
#include "lay_time.h"
#include "typ_time.h"
#include "typ_32.h"

char				*time_itmpl = "\n\
<!--time_tmpl-->\n\
<table bgcolor=\"%%timeColor%%\" width=100%%%%>\n\
<tr>\n\
<td>\n\
<small>\n\
<a href=\"extract(time[%i%])\">[E]</a>\n\
<a href=\"trunc(time[%i%])\">[T]</a>\n\
<a href=\"paste(time[%i%])\">[P]</a>\n\
</small>\n\
</td>\n\
<td align=center width=100%%%%>\n\
<small>\n\
<a href=\"setfield(time[%i%].Time)\">%%time[%i%].Time%%</a>\n\
(<a href=\"setfield(time[%i%].time)\">%%time[%i%].time%%</a>)\n\
</small>\n\
</td>\n\
</tr>\n\
</table>\n\
";

t_field				time_fields[] = 
{
  {"time",	0,	typ_u32_msg,		NULL},
  {"Time",	0,	typ_time_msg,		NULL},
  NULL_FIELD
};

t_status			lay_time_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  t_status			status;

  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_time_msg,"time");
      LAY_GET_FIELD_GENERIC(time_fields);
      LAY_SET_FIELD_GENERIC(time_fields);
      LAY_GET_FIELDS_GENERIC(time_fields);
      LAY_GET_FIELD_TYP_GENERIC(time_fields);
      LAY_GET_ITMPL_GENERIC(&lay_time_msg,time_itmpl);
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = sizeof (t_u32);
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	(*mp) = &lay_time_msg;
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}
