/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "layer.h"
#include "lay_data.h"
#include "lay_tftp.h"
#include "lay_tftpmode.h"
#include "typ_sz.h"

t_field				tftpmode_fields[] = 
{
  {"mode",	0,		typ_sz_msg,		NULL},
  NULL_FIELD
};

char				*tftpmode_itmpl = "\n\
<!--tftpmode_tmpl-->\n\
<table width=100%%%% bgcolor=\"%%tftpmodeColor%%\">\n\
<tr>\n\
<td width=100%%%%>\n\
<small>\n\
<a href=\"extract(tftpmode[%i%])\">[Extract]</a>\n\
<a href=\"trunc(tftpmode[%i%])\">[Trunc]</a>\n\
<a href=\"paste(tftpmode[%i%])\">[Paste]</a>\n\
 tftp mode\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=50%%%%>\n\
<a href=\"setfield(tftpmode[%i%].mode)\">%%tftpmode[%i%].mode%%</a>\n\
</td>\n\
</tr>\n\
</table>\n\
";

t_status			lay_tftpmode_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_tftpmode_msg,"tftpmode");
      LAY_GET_FIELD_GENERIC(tftpmode_fields);
      LAY_SET_FIELD_GENERIC(tftpmode_fields);
      LAY_GET_FIELDS_GENERIC(tftpmode_fields);
      LAY_GET_FIELD_TYP_GENERIC(tftpmode_fields);
      LAY_GET_ITMPL_GENERIC(&lay_tftpmode_msg,tftpmode_itmpl);
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	t_extract_data		ed;

	ed.b.buf = b->buf;
	ed.b.len = b->len;
	return (typ_msg(typ_sz_msg,
			TYP_OFF,
			&ed,
			off));
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	(*mp) = lay_data_msg;
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}
