/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <arpa/tftp.h>
#include "lay_ip.h"
#include "lay_ether.h"
#include "lay_tftperror.h"
#include "lay_data.h"
#include "typ_16.h"
#include "typ_sz.h"

t_assoc			tftpen_assocs[] =
{
  {"undef",		(VOID_PTR)EUNDEF},
  {"notfound",		(VOID_PTR)ENOTFOUND},
  {"access",		(VOID_PTR)EACCESS},
  {"nospace",		(VOID_PTR)ENOSPACE},
  {"badop",		(VOID_PTR)EBADOP},
  {"badid",		(VOID_PTR)EBADID},
  {"exists",		(VOID_PTR)EEXISTS},
  {"nouser",		(VOID_PTR)ENOUSER},
  {NULL,		NULL}
};

t_field				tftperror_fields[] = 
{
  {"en",	0,		typ_nu16_msg,		NULL},
  {"En",	0,		typ_nu16assoc_msg,	tftpen_assocs},
  {"msg",	2,		typ_sz_msg,		NULL},
  NULL_FIELD
};

char				*tftperror_itmpl = "\n\
<!--tftperror_tmpl-->\n\
<table width=100%%%% bgcolor=\"%%tftperrorColor%%\">\n\
<tr>\n\
<td width=100%%%%>\n\
<small>\n\
<a href=\"extract(tftperror[%i%])\">[Extract]</a>\n\
<a href=\"trunc(tftperror[%i%])\">[Trunc]</a>\n\
<a href=\"paste(tftperror[%i%])\">[Paste]</a>\n\
 tftp error\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"setfield(tftperror[%i%].En)\">%%tftperror[%i%].En%%</a>\n\
(<a href=\"setfield(tftperror[%i%].en)\">%%tftperror[%i%].en%%</a>)\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"setfield(tftperror[%i%].msg)\">%%tftperror[%i%].msg%%</a>\n\
</td>\n\
</tr>\n\
</table>\n\
";

t_status			lay_tftperror_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  t_status			status;

  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_tftperror_msg,"tftperror");
      LAY_GET_FIELD_GENERIC(tftperror_fields);
      LAY_SET_FIELD_GENERIC(tftperror_fields);
      LAY_GET_FIELDS_GENERIC(tftperror_fields);
      LAY_GET_FIELD_TYP_GENERIC(tftperror_fields);
      LAY_GET_ITMPL_GENERIC(&lay_tftperror_msg,tftperror_itmpl);
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	t_off			msgoff;
	t_extract_data		ed;

	if (b->len < 2)
	  return (-ERR_TRUNC);
	ed.b.buf = b->buf + 2;
	ed.b.len = b->len - 2;
	if ((status = typ_msg(typ_sz_msg,
			      TYP_OFF,
			      &ed,
			      &msgoff)) < 0)
	  return (status);
	(*off) = msgoff + 2;
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	(*mp) = lay_data_msg;
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}
