/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "lay_ip.h"
#include "lay_ether.h"
#include "lay_tftpbn.h"
#include "lay_data.h"
#include "typ_16.h"

t_field				tftpbn_fields[] = 
{
  {"bn",	0,		typ_nu16_msg,		NULL},
  NULL_FIELD
};

char				*tftpbn_itmpl = "\n\
<!--tftpbn_tmpl-->\n\
<table width=100%%%% bgcolor=\"%%tftpbnColor%%\">\n\
<tr>\n\
<td width=100%%%%>\n\
<small>\n\
<a href=\"extract(tftpbn[%i%])\">[Extract]</a>\n\
<a href=\"trunc(tftpbn[%i%])\">[Trunc]</a>\n\
<a href=\"paste(tftpbn[%i%])\">[Paste]</a>\n\
 tftp block number\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"setfield(tftpbn[%i%].bn)\">%%tftpbn[%i%].bn%%</a>\n\
</td>\n\
</tr>\n\
</table>\n\
";

t_status			lay_tftpbn_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_tftpbn_msg,"tftpbn");
      LAY_GET_FIELD_GENERIC(tftpbn_fields);
      LAY_SET_FIELD_GENERIC(tftpbn_fields);
      LAY_GET_FIELDS_GENERIC(tftpbn_fields);
      LAY_GET_FIELD_TYP_GENERIC(tftpbn_fields);
      LAY_GET_ITMPL_GENERIC(&lay_tftpbn_msg,tftpbn_itmpl);
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = 2;
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	(*mp) = lay_data_msg;
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}
