/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include "lay_rpccall.h"
#include "lay_data.h"
#include "typ_32.h"
#include "typ_rpc.h"

t_assoc				rpcproc_assocs[] =
{
  {"null",			(VOID_PTR)0},
  {"set",			(VOID_PTR)1},
  {"unset",			(VOID_PTR)2},
  {"getport",			(VOID_PTR)3},
  {"dump",			(VOID_PTR)4},
  {"callit",			(VOID_PTR)5},
  {NULL,			NULL},
};

t_status			rpccall_sub(buf,len,sub_mp)
char				*buf;
int				len;
t_msg_proc			*sub_mp;
{
  t_rpccall				*rpccall;
  
  LAYER_RPCCALL_CHECK(rpccall,buf,len);
  (*sub_mp) = &lay_data_msg;
  return (0);
}

t_field				rpccall_fields[] = 
{
  {"rpcversion",   OFFSET(t_rpccall *,rpcversion),	typ_nu32_msg,	NULL},
  {"program",   OFFSET(t_rpccall *,program),	typ_nu32_msg,	NULL},
  {"Program",   OFFSET(t_rpccall *,program),	typ_rpc_resolved_msg,	NULL},
  {"version",   OFFSET(t_rpccall *,version),	typ_nu32_msg,	NULL},
  {"procedure",   OFFSET(t_rpccall *,procedure),	typ_nu32_msg,	NULL},
  {"Procedure",OFFSET(t_rpccall *,procedure),typ_nu32assoc_msg,rpcproc_assocs},
  NULL_FIELD
};

char				*rpccall_itmpl = "\n\
<!--rpccall_itmpl-->\n\
<table width=100%%%% cellpadding=3 bgcolor=\"%%rpccallColor%%\">\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"setfield(rpccall[%i%].rpcversion)\">%%rpccall[%i%].rpcversion%%</a>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"setfield(rpccall[%i%].Program)\">%%rpccall[%i%].Program%%</a>\n\
(<a href=\"setfield(rpccall[%i%].program)\">%%rpccall[%i%].program%%</a>)\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"setfield(rpccall[%i%].version)\">%%rpccall[%i%].version%%</a>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"setfield(rpccall[%i%].Procedure)\">%%rpccall[%i%].Procedure%%</a>\n\
(<a href=\"setfield(rpccall[%i%].procedure)\">%%rpccall[%i%].procedure%%</a>)\n\
</td>\n\
</tr>\n\
<tr>\n\
<td width=100%%%% colspan=3>\n\
<small>\n\
<a href=\"extract(rpccall[%i%])\">[Extract]</a><a href=\"trunc(rpccall[%i%])\">[Trunc]</a>\n\
</small>\n\
</td>\n\
</tr>\n\
</table>\n\
";

t_status			lay_rpccall_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_rpccall_msg,"rpccall");
      LAY_GET_FIELD_GENERIC(rpccall_fields);
      LAY_SET_FIELD_GENERIC(rpccall_fields);
      LAY_GET_FIELDS_GENERIC(rpccall_fields);
      LAY_GET_FIELD_TYP_GENERIC(rpccall_fields);
      LAY_GET_ITMPL_GENERIC(&lay_rpccall_msg,rpccall_itmpl);
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = RPCCALL_HLEN;
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	return (rpccall_sub(b->buf,b->len,mp));
      }
    }
  return (-ERR_NOMETHOD);
}
