/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "lay_rip.h"
#include "lay_ip.h"
#include "lay_ether.h"
#include "lay_ripinfo.h"
#include "lay_data.h"
#include "typ_32.h"
#include "typ_16.h"
#include "typ_8.h"
#include "typ_inaddr.h"

t_assoc			family_assocs[] =
{
  {"unspec",		(VOID_PTR)AF_UNSPEC},               
  {"unix",		(VOID_PTR)AF_UNIX},               
  {"inet",		(VOID_PTR)AF_INET},               
  {NULL,		0},
};

t_status		ripinfo_sub(buf,len,sub_mp)
char			*buf;
int			len;
t_msg_proc		*sub_mp;
{
  t_ripinfo		*ripinfo;

  LAYER_RIPINFO_CHECK(ripinfo,buf,len);
  (*sub_mp) = &lay_ripinfo_msg;
  return (0);
}

t_field				ripinfo_fields[] = 
{
  {"family",	OFFSET(t_ripinfo *,family),	typ_nu16_msg,		NULL},
  {"Family",	OFFSET(t_ripinfo *,family),  typ_nu16assoc_msg,	family_assocs},
  {"tag",	OFFSET(t_ripinfo *,tag),	typ_nu16_msg,		NULL},
  {"dst",	OFFSET(t_ripinfo *,dst),	typ_inaddr_msg,		NULL},
  {"Dst",	OFFSET(t_ripinfo *,dst),	typ_inaddr_resolved_msg,NULL},
  {"mask",	OFFSET(t_ripinfo *,mask),	typ_inaddr_msg,		NULL},
  {"Mask",	OFFSET(t_ripinfo *,mask),	typ_inaddr_resolved_msg,NULL},
  {"router",	OFFSET(t_ripinfo *,router),	typ_inaddr_msg,		NULL},
  {"Router",	OFFSET(t_ripinfo *,router),	typ_inaddr_resolved_msg,NULL},
  {"metric",	OFFSET(t_ripinfo *,metric),	typ_nu32_msg,		NULL},
  NULL_FIELD
};

char				*ripinfo_itmpl = "\n\
<!--ripinfo_tmpl-->\n\
<table width=100%%%% bgcolor=\"%%ripinfoColor%%\">\n\
<tr>\n\
<td width=100%%%%>\n\
<small>\n\
<a href=\"extract(ripinfo[%i%])\">[Extract]</a>\n\
<a href=\"trunc(ripinfo[%i%])\">[Trunc]</a>\n\
<a href=\"paste(ripinfo[%i%])\">[Paste]</a>\n\
 ripinfo\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=50%%%%>\n\
<a href=\"setfield(ripinfo[%i%].Family)\">%%ripinfo[%i%].Family%%</a>\n\
(<a href=\"setfield(ripinfo[%i%].family)\">%%ripinfo[%i%].family%%</a>)\n\
</td>\n\
<td align=center width=50%%%%>\n\
<a href=\"setfield(ripinfo[%i%].tag)\">%%ripinfo[%i%].tag%%</a>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"setfield(ripinfo[%i%].Dst)\">%%ripinfo[%i%].Dst%%</a>\n\
(<a href=\"setfield(ripinfo[%i%].dst)\">%%ripinfo[%i%].dst%%</a>)\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"setfield(ripinfo[%i%].Mask)\">%%ripinfo[%i%].Mask%%</a>\n\
(<a href=\"setfield(ripinfo[%i%].mask)\">%%ripinfo[%i%].mask%%</a>)\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"setfield(ripinfo[%i%].Router)\">%%ripinfo[%i%].Router%%</a>\n\
(<a href=\"setfield(ripinfo[%i%].router)\">%%ripinfo[%i%].router%%</a>)\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"setfield(ripinfo[%i%].metric)\">%%ripinfo[%i%].metric%%</a>\n\
</td>\n\
</tr>\n\
</table>\n\
";

t_status			lay_ripinfo_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_ripinfo_msg,"ripinfo");
      LAY_GET_FIELD_GENERIC(ripinfo_fields);
      LAY_SET_FIELD_GENERIC(ripinfo_fields);
      LAY_GET_FIELDS_GENERIC(ripinfo_fields);
      LAY_GET_FIELD_TYP_GENERIC(ripinfo_fields);
      LAY_GET_ITMPL_GENERIC(&lay_ripinfo_msg,ripinfo_itmpl);
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = RIPINFO_HLEN;
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	return (ripinfo_sub(b->buf,b->len,mp));
      }
    }
  return (-ERR_NOMETHOD);
}
