/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "lay_rip.h"
#include "lay_ip.h"
#include "lay_ether.h"
#include "lay_ripinfo.h"
#include "lay_data.h"
#include "typ_16.h"
#include "typ_8.h"

t_assoc				ripcmd_assocs[] =
{
  {"request",			(VOID_PTR)1},
  {"response",			(VOID_PTR)2},
  {"traceon",			(VOID_PTR)3},
  {"traceoff",			(VOID_PTR)4},
  {"poll",			(VOID_PTR)5},
  {"pollentry",			(VOID_PTR)6},
  {NULL,			NULL},
};

t_status	rip_sub(buf,len,sub_mp)
char		*buf;
int		len;
t_msg_proc	*sub_mp;
{
  t_rip		*rip;

  LAYER_RIP_CHECK(rip,buf,len);
  (*sub_mp) = &lay_ripinfo_msg;
  return (0);
}

t_field				rip_fields[] = 
{
  {"cmd",	OFFSET(t_rip *,cmd),	typ_u8_msg,		NULL},
  {"Cmd",	OFFSET(t_rip *,cmd),	typ_u8assoc_msg,  ripcmd_assocs},
  {"v",		OFFSET(t_rip *,v),	typ_u8_msg,		NULL},
  {"mbz",	OFFSET(t_rip *,mbz),	typ_nu16_msg,		NULL},
  NULL_FIELD
};

char				*rip_itmpl = "\n\
<!--rip_itmpl-->\n\
<table width=100%%%% bgcolor=\"%%ripColor%%\">\n\
<tr>\n\
<td width=100%%%%>\n\
<small>\n\
<a href=\"extract(rip[%i%])\">[Extract]</a>\n\
<a href=\"trunc(rip[%i%])\">[Trunc]</a>\n\
<a href=\"paste(rip[%i%])\">[Paste]</a>\n\
 rip\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=25%%%%>\n\
<a href=\"setfield(rip[%i%].Cmd)\">%%rip[%i%].Cmd%%</a>\n\
(<a href=\"setfield(rip[%i%].cmd)\">%%rip[%i%].cmd%%</a>)\n\
</td>\n\
<td align=center width=25%%%%>\n\
<a href=\"setfield(rip[%i%].v)\">%%rip[%i%].v%%</a>\n\
</td>\n\
<td align=center width=50%%%%>\n\
<a href=\"setfield(rip[%i%].mbz)\">%%rip[%i%].mbz%%</a>\n\
</td>\n\
</tr>\n\
</table>\n\
";

t_status			lay_rip_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_rip_msg,"rip");
      LAY_GET_FIELD_GENERIC(rip_fields);
      LAY_SET_FIELD_GENERIC(rip_fields);
      LAY_GET_FIELDS_GENERIC(rip_fields);
      LAY_GET_FIELD_TYP_GENERIC(rip_fields);
      LAY_GET_ITMPL_GENERIC(&lay_rip_msg,rip_itmpl);
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = RIP_HLEN;
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	return (rip_sub(b->buf,b->len,mp));
      }
    }
  return (-ERR_NOMETHOD);
}
