/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include "lay_null.h"
#include "lay_ip.h"
#include "lay_arp.h"
#include "lay_data.h"
#include "typ_ethaddr.h"
#include "typ_32.h"
#include "typ_mac.h"
#include "lay_ripinfo.h"

t_status		null_sub(buf,len,sub_mp)
char			*buf;
int			len;
t_msg_proc		*sub_mp;
{
  t_null		*null;
  t_u32			family;

  LAYER_NULL_CHECK(null,buf,len);
  family = safe_ntohl(&(null->family));
  switch (family)
    {
    case AF_INET:
	(*sub_mp) = &lay_ip_msg;
	return (0);
    }
  (*sub_mp) = &lay_data_msg;
  return (0);
}

t_field				null_fields[] = 
{
  {"family",	OFFSET(t_null *,family),typ_nu32_msg,	NULL},
  {"Family",	OFFSET(t_null *,family),typ_nu32assoc_msg,	family_assocs},
  NULL_FIELD
};

char				*null_itmpl = "\n\
<!--null_itmpl-->\n\
<table width=100%%%% cellpadding=3 bgcolor=\"%%nullColor%%\">\n\
<tr>\n\
<td width=100%%%% colspan=3>\n\
<small>\n\
<a href=\"extract(null[%i%])\">[Extract]</a>\n\
<a href=\"trunc(null[%i%])\">[Trunc]</a>\n\
<a href=\"paste(null[%i%])\">[Paste]</a>\n\
 null\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<a href=\"setfield(null[%i%].Family)\">%%null[%i%].Family%%</a>\n\
(<a href=\"setfield(null[%i%].family)\">%%null[%i%].family%%</a>)\n\
</td>\n\
</tr>\n\
</table>\n\
";

t_status			lay_null_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_null_msg,"null");
      LAY_GET_FIELD_GENERIC(null_fields);
      LAY_SET_FIELD_GENERIC(null_fields);
      LAY_GET_FIELDS_GENERIC(null_fields);
      LAY_GET_FIELD_TYP_GENERIC(null_fields);
      LAY_GET_ITMPL_GENERIC(&lay_null_msg,null_itmpl);
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = NULL_HLEN;
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	return (null_sub(b->buf,b->len,mp));
      }
    }
  return (-ERR_NOMETHOD);
}
