/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "layer.h"
#include "lay_data.h"
#include "lay_ipopt.h"
#include "lay_inaddr.h"
#include "lay_inaddrtime.h"
#include "lay_time.h"
#include "typ_8.h"

/*
 Copy Class Number Value Name                            Reference
---- ----- ------ ----- ------------------------------- ---------
   0     0      0     0 EOOL   - End of Options List    [RFC791,JBP]
   0     0      1     1 NOP    - No Operation           [RFC791,JBP]
   1     0      2   130 SEC    - Security                  [RFC1108]
   1     0      3   131 LSR    - Loose Source Route     [RFC791,JBP]
   0     2      4    68 TS     - Time Stamp             [RFC791,JBP]
   1     0      5   133 E-SEC  - Extended Security         [RFC1108]
   1     0      6   134 CIPSO  - Commercial Security           [???]
   0     0      7     7 RR     - Record Route           [RFC791,JBP]
   1     0      8   136 SID    - Stream ID              [RFC791,JBP]
   1     0      9   137 SSR    - Strict Source Route    [RFC791,JBP]
   0     0     10    10 ZSU    - Experimental Measurement      [ZSu]
   0     0     11    11 MTUP   - MTU Probe                 [RFC1191]
   0     0     12    12 MTUR   - MTU Reply                 [RFC1191]
   1     2     13   205 FINN   - Experimental Flow Control    [Finn]
   1     0     14   142 VISA   - Expermental Access Control [Estrin]
   0     0     15    15 ENCODE - ???                      [VerSteeg]
   1     0     16   144 IMITD  - IMI Traffic Descriptor        [Lee]
   1     0     17   145 EIP    - ???                       [RFC1358]
   0     2     18    82 TR     - Traceroute                [RFC1393]
   1     0     19   147 ADDEXT - Address Extension    [Ullmann IPv7] 
   */

t_assoc			ipopt_assocs[] = 
{
  {"eool",		(VOID_PTR)IPOPT_EOOL},
  {"nop",		(VOID_PTR)IPOPT_NOP},
  {"sec",		(VOID_PTR)130},
  {"lsr",		(VOID_PTR)IPOPT_LSR},
  {"ts",		(VOID_PTR)IPOPT_TS},
  {"e-sec",		(VOID_PTR)133},
  {"cipso",		(VOID_PTR)134},
  {"rr",		(VOID_PTR)IPOPT_RR},
  {"sid",		(VOID_PTR)136},
  {"ssr",		(VOID_PTR)IPOPT_SSR},
  {"zsu",		(VOID_PTR)10},
  {"mtup",		(VOID_PTR)11},
  {"mtur",		(VOID_PTR)12},
  {"finn",		(VOID_PTR)205},
  {"visa",		(VOID_PTR)142},
  {"encode",		(VOID_PTR)15},
  {"imitd",		(VOID_PTR)144},
  {"eip",		(VOID_PTR)145},
  {"tr",		(VOID_PTR)82},
  {"addext",		(VOID_PTR)147},
  {NULL,		0},
};

t_field				ipopt_simple_fields[] = 
{
  {"code",	0,	typ_u8_msg,		NULL},
  {"Code",	0,	typ_u8assoc_msg,	(VOID_PTR)ipopt_assocs},
  NULL_FIELD
};

t_field				ipopt_double_fields[] = 
{
  {"code",	0,	typ_u8_msg,		NULL},
  {"Code",	0,	typ_u8assoc_msg,	(VOID_PTR)ipopt_assocs},
  {"len",	1,	typ_u8_msg,		NULL},
  NULL_FIELD
};

t_field				ipopt_rr_fields[] = 
{
  {"code",	0,	typ_u8_msg,		NULL},
  {"Code",	0,	typ_u8assoc_msg,	(VOID_PTR)ipopt_assocs},
  {"len",	1,	typ_u8_msg,		NULL},
  {"ptr",	2,	typ_u8_msg,		NULL},
  NULL_FIELD
};

t_bit_field	ipopt_ts_of_bit_field =
{
  0,3
};	

t_bit_field	ipopt_ts_fl_bit_field =
{
  4,7
};	

t_assoc		ipopt_ts_fl_assocs[] = 
{
  {"ts_only",		(VOID_PTR)0},
  {"both",		(VOID_PTR)1},
  {"match",		(VOID_PTR)2},
  {NULL,		NULL},	
};

t_bit_field_assocs_data	ipopt_ts_fl_bfad = 
{
  &ipopt_ts_fl_bit_field,
  ipopt_ts_fl_assocs
};

t_field				ipopt_ts_fields[] = 
{
  {"code",	0,	typ_u8_msg,		NULL},
  {"Code",	0,	typ_u8assoc_msg,	(VOID_PTR)ipopt_assocs},
  {"len",	1,	typ_u8_msg,		NULL},
  {"ptr",	2,	typ_u8_msg,		NULL},
  {"of",	3,typ_u8bitfield_msg,	(VOID_PTR)(&ipopt_ts_of_bit_field)},
  {"fl",	3,typ_u8bitfield_msg,	(VOID_PTR)(&ipopt_ts_fl_bit_field)},
  {"Fl",	3,typ_u8bitfieldassoc_msg,(VOID_PTR)(&ipopt_ts_fl_bfad)},
  NULL_FIELD
};

t_field			*ipopt_get_fields(buf,len,status)
char			*buf;
int			len;
t_status		*status;
{
  if (len < 1)
    {
      *status = -ERR_TRUNC;
      return (NULL);
    }
  switch ((t_u8)(buf[0]))
    {
    case IPOPT_EOOL:
    case IPOPT_NOP:
      return (ipopt_simple_fields);
    case IPOPT_RR:
    case IPOPT_LSR:
    case IPOPT_SSR:
      return (ipopt_rr_fields);
    case IPOPT_TS:
      return (ipopt_ts_fields);
    default:
      return (ipopt_double_fields);
    }
}

char				*ipopt_simple_itmpl = "\n\
<!--ipopt_simple_itmpl-->\n\
<table bgcolor=\"%%ipoptColor%%\" width=100%%%%>\n\
<tr>\n\
<td>\n\
<small>\n\
<a href=\"extract(ipopt[%i%])\">[Extract]</a>\n\
<a href=\"trunc(ipopt[%i%])\">[Trunc]</a>\n\
<a href=\"trunc(ipopt[%i%])\">[Paste]</a>\n\
<a href=\"adaptlen(ipopt[%i%])\">[Adapt len]</a>\n\
 ipopt_simple\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=100%%%%>\n\
<small>\n\
<a href=\"setfield(ipopt[%i%].Code)\">%%ipopt[%i%].Code%%</a>\n\
(<a href=\"setfield(ipopt[%i%].code)\">%%ipopt[%i%].code%%</a>)\n\
</small>\n\
</td>\n\
</tr>\n\
</table>\n\
";

char				*ipopt_double_itmpl = "\n\
<!--ipopt_double_itmpl-->\n\
<table bgcolor=\"%%ipoptColor%%\" width=100%%%%>\n\
<tr>\n\
<td>\n\
<small>\n\
<a href=\"extract(ipopt[%i%])\">[Extract]</a>\n\
<a href=\"trunc(ipopt[%i%])\">[Trunc]</a>\n\
<a href=\"paste(ipopt[%i%])\">[Paste]</a>\n\
<a href=\"adaptlen(ipopt[%i%])\">[Adapt len]</a>\n\
 ipopt_double\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=50%%%%>\n\
<small>\n\
<a href=\"setfield(ipopt[%i%].Code)\">%%ipopt[%i%].Code%%</a>\n\
(<a href=\"setfield(ipopt[%i%].code)\">%%ipopt[%i%].code%%</a>)\n\
</small>\n\
</td>\n\
<td align=center width=50%%%%>\n\
<small>\n\
<a href=\"setfield(ipopt[%i%].len)\">%%ipopt[%i%].len%%</a>\n\
</small>\n\
</td>\n\
</tr>\n\
</table>\n\
";

char				*ipopt_rr_itmpl = "\n\
<!--ipopt_rr_itmpl-->\n\
<table bgcolor=\"%%ipoptColor%%\" width=100%%%%>\n\
<tr>\n\
<td>\n\
<small>\n\
<a href=\"extract(ipopt[%i%])\">[Extract]</a>\n\
<a href=\"trunc(ipopt[%i%])\">[Trunc]</a>\n\
<a href=\"paste(ipopt[%i%])\">[Paste]</a>\n\
<a href=\"adaptlen(ipopt[%i%])\">[Adapt len]</a>\n\
 ipopt_rr\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=33%%%%>\n\
<small>\n\
<a href=\"setfield(ipopt[%i%].Code)\">%%ipopt[%i%].Code%%</a>\n\
(<a href=\"setfield(ipopt[%i%].code)\">%%ipopt[%i%].code%%</a>)\n\
</small>\n\
</td>\n\
<td align=center width=33%%%%>\n\
<small>\n\
<a href=\"setfield(ipopt[%i%].len)\">%%ipopt[%i%].len%%</a>\n\
</small>\n\
</td>\n\
<td align=center width=33%%%%>\n\
<small>\n\
<a href=\"setfield(ipopt[%i%].ptr)\">%%ipopt[%i%].ptr%%</a>\n\
</small>\n\
</td>\n\
</tr>\n\
</table>\n\
";

char				*ipopt_ts_itmpl = "\n\
<!--ipopt_ts_itmpl-->\n\
<table bgcolor=\"%%ipoptColor%%\" width=100%%%%>\n\
<tr>\n\
<td>\n\
<small>\n\
<a href=\"extract(ipopt[%i%])\">[Extract]</a>\n\
<a href=\"trunc(ipopt[%i%])\">[Trunc]</a>\n\
<a href=\"paste(ipopt[%i%])\">[Paste]</a>\n\
<a href=\"adaptlen(ipopt[%i%])\">[Adapt len]</a>\n\
 ipopt_ts\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=25%%%%>\n\
<small>\n\
<a href=\"setfield(ipopt[%i%].Code)\">%%ipopt[%i%].Code%%</a>\n\
(<a href=\"setfield(ipopt[%i%].code)\">%%ipopt[%i%].code%%</a>)\n\
</small>\n\
</td>\n\
<td align=center width=25%%%%>\n\
<small>\n\
<a href=\"setfield(ipopt[%i%].len)\">%%ipopt[%i%].len%%</a>\n\
</small>\n\
</td>\n\
<td align=center width=25%%%%>\n\
<small>\n\
<a href=\"setfield(ipopt[%i%].ptr)\">%%ipopt[%i%].ptr%%</a>\n\
</small>\n\
</td>\n\
<td align=center width=12%%%%>\n\
<small>\n\
<a href=\"setfield(ipopt[%i%].of)\">%%ipopt[%i%].of%%</a>\n\
</small>\n\
</td>\n\
<td align=center width=13%%%%>\n\
<small>\n\
<a href=\"setfield(ipopt[%i%].Fl)\">%%ipopt[%i%].Fl%%</a>\n\
(<a href=\"setfield(ipopt[%i%].fl)\">%%ipopt[%i%].fl%%</a>)\n\
</small>\n\
</td>\n\
</tr>\n\
</table>\n\
";

char			*ipopt_get_itmpl(buf,len,status)
char			*buf;
int			len;
t_status		*status;
{
  if (len < 1)
    {
      *status = -ERR_TRUNC;
      return (NULL);
    }
  switch ((t_u8)(buf[0]))
    {
    case IPOPT_EOOL:
    case IPOPT_NOP:
      return (ipopt_simple_itmpl);
    case IPOPT_RR:
    case IPOPT_LSR:
    case IPOPT_SSR:
      return (ipopt_rr_itmpl);
    case IPOPT_TS:
      return (ipopt_ts_itmpl);
    default:
      return (ipopt_double_itmpl);
    }
}

t_status		ipopt_has_opt(buf,len,hsd)
char			*buf;
int			len;
t_has_opt_data		*hsd;
{
  if (len < 1)
    return (-ERR_TRUNC);
  switch ((t_u8)(buf[0]))
    {
    case IPOPT_RR:
    case IPOPT_LSR:
    case IPOPT_SSR:
      {
	if (len < 2)
	  return (-ERR_TRUNC);
	hsd->has_opt = TRUE;
	hsd->opt_off = 3;
	if ((t_u8)(buf[1]) < 3)
	  {
	    hsd->has_opt = FALSE;
	    return (0);
	  }
	hsd->opt_len = (t_u8)(buf[1]) - 3;
	hsd->opt_mp = lay_inaddr_msg;
	return (0);
      }
    case IPOPT_TS:
      {
	t_u8		*fl;

	if (len < 4)
	  return (-ERR_TRUNC);
	hsd->has_opt = TRUE;
	hsd->opt_off = 4;
	if ((t_u8)(buf[1]) < 4)
	  {
	    hsd->has_opt = FALSE;
	    return (0);
	  }
	hsd->opt_len = (t_u8)(buf[1]) - 4;
	fl = bit_field_u8_get((t_u8 *)(buf + 3),
			      ipopt_ts_fl_bit_field.from,
			      ipopt_ts_fl_bit_field.to);
	if (*fl == 0)
	  hsd->opt_mp = lay_time_msg;
	else
	  hsd->opt_mp = lay_inaddrtime_msg;
	return (0);
      }
    default:
      {
	hsd->has_opt = FALSE;
	return (0);
      }
    }
}

char				*ipoptdata_itmpl = "\n\
<!--ipoptdata_itmpl-->\n\
<table width=100%%%% bgcolor=\"%%ipoptColor%%\">\n\
<tr>\n\
<td width=100%%%%>\n\
<small>\n\
<a href=\"extract(ipoptdata[%i%])\">[Extract]</a>\n\
<a href=\"paste(ipoptdata[%i%])\">[Paste]</a>\n\
 ipoptdata %%ipoptdata[%i%].len%% byte(s)\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td width=100%%%%>\n\
<code>\n\
%%ipoptdata[%i%].cookedhtmlbuf%%\n\
</code>\n\
</tr>\n\
</table>\n\
";

t_status			lay_ipoptdata_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;	
{
  t_status			status;

  switch (msg)
    {
    LAY_CLASS_GENERIC;
    LAY_NAME_ID_GENERIC(&lay_ipoptdata_msg,"ipoptdata");
    LAY_GET_ITMPL_GENERIC(&lay_ipoptdata_msg,ipoptdata_itmpl);
    }
  return (lay_data_msg(msg,arg1,arg2));
}

t_status			lay_ipopt_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  t_status			status;

  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_ipopt_msg,"ipopt");
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);

	if (b->len < 1)
	  return (-ERR_TRUNC);
	switch ((t_u8)(b->buf[0]))
	  {
	  case IPOPT_EOOL:
	  case IPOPT_NOP:
	    (*off) = 1;
	    return (0);
	  }
	if (b->len < 2)
	  return (-ERR_TRUNC);
	(*off) = (t_off)(t_u8)(b->buf[1]);
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,sub_mp);
		
	if (b->len < 1)
	  return (-ERR_TRUNC);
	switch ((t_u8)(b->buf[0]))
	  {
	  case IPOPT_EOOL:
	    (*sub_mp) = &lay_ipoptdata_msg;
	    return (0);
	  }
	(*sub_mp) = &lay_ipopt_msg;
	return (0);
      }
    case LAY_GET_FIELD:
      {
	LAY_GET_FIELD_ARGS(gfd,bs);
	t_field			*fields;
	t_field			*field;
	
	if ((fields = ipopt_get_fields(gfd->b.buf,
				       gfd->b.len,
				       &status)) == NULL)
	  return (status);
	field = NULL;
	while (fields->name)
	  {
	    if (!strcmp(fields->name,gfd->field))
	      field = fields;
	    fields++;
	  }
	if (!field)
	  return (-ERR_NOENT);
	return (get_field_to_str(gfd->b.buf,
				 gfd->b.len,
				 field,
				 bs->str,
				 bs->max_len));
      }
    case LAY_SET_FIELD:
      {
	LAY_SET_FIELD_ARGS(gfd,str);
	t_field			*fields;
	t_field			*field;
	
	if ((fields = ipopt_get_fields(gfd->b.buf,
				       gfd->b.len,
				       &status)) == NULL)
	  return (status);
	field = NULL;
	while (fields->name)
	  {
	    if (!strcmp(fields->name,gfd->field))
	      field = fields;
	    fields++;
	  }
	if (!field)
	  return (-ERR_NOENT);
	return (set_field_from_str(gfd->b.buf,
				   gfd->b.len,
				   field,
				   str));
      }
    case LAY_GET_FIELD_TYP:
      {
	LAY_GET_FIELD_TYP_ARGS(gfd,gftd);
	t_field			*fields;	

	if ((fields = ipopt_get_fields(gfd->b.buf,
				       gfd->b.len,
				       &status)) == NULL)
	  return (status);
	while (fields->name)
	  {
	    if (!strcmp(gfd->field,fields->name))
	      {
		gftd->mp = fields->mp;
		gftd->data = fields->data;
		return (0);
	      }
	    fields++;
	  }
	return (-ERR_NOENT);
      }
    case LAY_GET_TMPL:
      {
	LAY_GET_TMPL_ARGS(gtd,bs);
	char		*itmpl;
	t_hash_elt	*he;
	int		i;

	if ((itmpl = ipopt_get_itmpl(gtd->b.buf,
				     gtd->b.len,
				     &status)) == NULL)
	  return (status);
	if (he = id_get(gtd->id,
			&lay_ipopt_msg))
	  i = (int)(he->value);
	else
	  i = 0;
	if ((status = itmpl_format(i,
				   itmpl,
				   bs->str,
				   bs->max_len)) < 0)
	  return (status);
	if ((status = id_override(gtd->id,
				  &lay_ipopt_msg,
				  (VOID_PTR)(++i))) < 0)
	  return (status);
	return (0);
      }
    case LAY_HAS_OPT:
      {
	LAY_HAS_OPT_ARGS(b,hsd);
	
	return (ipopt_has_opt(b->buf,b->len,hsd));
      }
    }
  return (-ERR_NOMETHOD);
}
