/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "lay_ether.h"
#include "lay_ieee802.h"
#include "lay_ip.h"
#include "lay_arp.h"
#include "lay_data.h"
#include "typ_ethaddr.h"
#include "typ_16.h"
#include "typ_mac.h"

t_assoc			ethertype_assocs[] = 
{
  {"pup",		(VOID_PTR)0x0200},
  {"ip",		(VOID_PTR)ETHERTYPE_IP},
  {"arp",		(VOID_PTR)ETHERTYPE_ARP},
  {"lat",		(VOID_PTR)0x6004},
  {"decnet",		(VOID_PTR)0x6003},
  {"moprc",		(VOID_PTR)0x6002},
  {"mopdl",		(VOID_PTR)0x6001},
  {"atalk",		(VOID_PTR)ETHERTYPE_ATALK},
  {"rarp",		(VOID_PTR)ETHERTYPE_RARP},
  {"loopback",		(VOID_PTR)0x9000},
  {NULL,		0},
};

VOID_FUNC		ether_set_shost(ether,ea)
t_ether			*ether;
t_ether_addr		*ea;
{
  FBCOPY(ea,ether->shost,sizeof (t_ether_addr)); 
}

VOID_FUNC		ether_get_shost(ether,ea)
t_ether			*ether;
t_ether_addr		*ea;
{
  FBCOPY(ether->shost,ea,sizeof (t_ether_addr));
}

VOID_FUNC		ether_set_dhost(ether,ea)
t_ether			*ether;
t_ether_addr		*ea;
{
  FBCOPY(ea,ether->dhost,sizeof (t_ether_addr)); 
}

VOID_FUNC		ether_get_dhost(ether,ea)
t_ether			*ether;
t_ether_addr		*ea;
{
  FBCOPY(ether->dhost,ea,sizeof (t_ether_addr));
}

VOID_FUNC		ether_set_type(ether,type)
t_ether			*ether;
int			type;
{
  safe_htons(type,&(ether->type));
}

int			ether_get_type(ether)
t_ether			*ether;
{
  return (safe_ntohs(&(ether->type)));
}

t_status		ether_sub(buf,len,sub_mp)
char			*buf;
int			len;
t_msg_proc		*sub_mp;
{
  t_ether		*ether;
  int			type;

  LAYER_ETHER_CHECK(ether,buf,len);
  type = ether_get_type(ether);
  if (type <= 0x5dc)
    {
      (*sub_mp) = &lay_llc_msg;
      return (0);
    }
  switch (type)
    {
      case ETHERTYPE_IP:
	(*sub_mp) = &lay_ip_msg;
	return (0);
      case ETHERTYPE_ARP:
	(*sub_mp) = &lay_arp_msg;
	return (0);
    }
  (*sub_mp) = &lay_data_msg;
  return (0);
}

t_field				ether_fields[] = 
{
  {"dhost",	OFFSET(t_ether *,dhost),	typ_etheraddr_msg,	NULL},
  {"Dhost",	OFFSET(t_ether *,dhost),	typ_mac_msg,		NULL},
  {"shost",	OFFSET(t_ether *,shost),	typ_etheraddr_msg,	NULL},
  {"Shost",	OFFSET(t_ether *,shost),	typ_mac_msg,		NULL},
  {"type",	OFFSET(t_ether *,type),		typ_nu16_msg,		NULL},
  {"Type",	OFFSET(t_ether *,type),	typ_nu16assoc_msg,   ethertype_assocs},
  NULL_FIELD
};

char				*ether_itmpl = "\n\
<!--ether_itmpl-->\n\
<table width=100%%%% cellpadding=3 bgcolor=\"%%etherColor%%\">\n\
<tr>\n\
<td>\n\
<small>\n\
<a href=\"extract(ether[%i%])\">[Extract]</a>\n\
<a href=\"trunc(ether[%i%])\">[Trunc]</a>\n\
<a href=\"paste(ether[%i%])\">[Paste]</a>\n\
 ether\n\
</small>\n\
</td>\n\
</tr>\n\
<tr>\n\
<td align=center width=40%%%%>\n\
<a href=\"setfield(ether[%i%].shost)\">%%ether[%i%].shost%%</a>\n\
<_tiny>\n\
<a href=\"setfield(ether[%i%].Shost)\">%%ether[%i%].Shost%%</a>\n\
</_tiny>\n\
</td>\n\
<td align=center width=40%%%%>\n\
<a href=\"setfield(ether[%i%].dhost)\">%%ether[%i%].dhost%%</a>\n\
<_tiny>\n\
<a href=\"setfield(ether[%i%].Dhost)\">%%ether[%i%].Dhost%%</a>\n\
</_tiny>\n\
</td>\n\
<td align=center width=20%%%%>\n\
<a href=\"setfield(ether[%i%].Type)\">%%ether[%i%].Type%%</a>\n\
(<a href=\"setfield(ether[%i%].type)\">%%ether[%i%].type%%</a>)\n\
</td>\n\
</tr>\n\
</table>\n\
";

t_status			lay_ether_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_ether_msg,"ether");
      LAY_GET_FIELD_GENERIC(ether_fields);
      LAY_SET_FIELD_GENERIC(ether_fields);
      LAY_GET_FIELDS_GENERIC(ether_fields);
      LAY_GET_FIELD_TYP_GENERIC(ether_fields);
      LAY_GET_ITMPL_GENERIC(&lay_ether_msg,ether_itmpl);
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = ETHER_HLEN;
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	return (ether_sub(b->buf,b->len,mp));
      }
    }
  return (-ERR_NOMETHOD);
}
