/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <arpa/nameser.h>
#include "layer.h"
#include "lay_data.h"
#include "lay_dnsqtype.h"
#include "lay_dnsqname.h"
#include "typ_dnsqname.h"

char				*dnsqname_itmpl = "\n\
<!--dnsqname_itmpl-->\n\
<table bgcolor=\"%%dnsqnameColor%%\" width=100%%%%>\n\
<tr>\n\
<td>\n\
<small>\n\
<a href=\"extract(dnsqname[%i%])\">[E]</a>\n\
<a href=\"trunc(dnsqname[%i%])\">[T]</a>\n\
<a href=\"paste(dnsqname[%i%])\">[P]</a>\n\
</small>\n\
</td>\n\
<td align=center width=100%%%%>\n\
<small>\n\
<a href=\"setfield(dnsqname[%i%].name)\">%%dnsqname[%i%].name%%</a>\n\
</small>\n\
</td>\n\
</tr>\n\
</table>\n\
";

t_field				dnsqname_fields[] = 
{
  {"name",	0,	typ_dnsqname_msg,		NULL},
  NULL_FIELD
};

t_status			lay_dnsqname_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  t_status			status;

  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_dnsqname_msg,"dnsqname");
      LAY_SET_FIELD_GENERIC(dnsqname_fields);
      LAY_GET_FIELDS_GENERIC(dnsqname_fields);
      LAY_GET_FIELD_TYP_GENERIC(dnsqname_fields);
      LAY_GET_ITMPL_GENERIC(&lay_dnsqname_msg,dnsqname_itmpl);
    case LAY_GET_FIELD:
      {
	LAY_GET_FIELD_ARGS(gfd,bs);

	if (!strcmp(gfd->field,"name"))
	  {
	    int			len;
	    t_extract_data	ed;

	    if (gfd->b.len < 1)
	      return (-ERR_TRUNC);
	    len = (t_u32)(t_u8)(gfd->b.buf[0]);
	    if ((len & INDIR_MASK) == INDIR_MASK)
	      return (-ERR_CANTHANDLE);
	    ed.b.buf = gfd->b.buf;
	    ed.b.len = gfd->b.len;
	    ed.data = NULL;
	    return (typ_msg(typ_dnsqname_msg,
			    TYP_EXTRACT,
			    &ed,
			    bs));
	  }
	return (-ERR_NOSUCHFIELD);
      }
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	t_extract_data		ed;
	int			len;
	
	if (b->len < 1)
	  return (-ERR_TRUNC);
	len = (t_u32)(t_u8)(b->buf[0]);
	if ((len & INDIR_MASK) == INDIR_MASK)
	  {
	    (*off) = 1 + 1;
	    return (0);
	  }
	ed.b.buf = b->buf;
	ed.b.len = b->len;
	ed.data = NULL;
	return (typ_msg(typ_dnsqname_msg,
			TYP_OFF,
			&ed,
			off));
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	int			len;

	if (b->len < 1)
	  return (-ERR_TRUNC);
	len = (t_u32)(t_u8)(b->buf[0]);
	if ((len & INDIR_MASK) == INDIR_MASK)
	  {
	    (*mp) = lay_dnsqtype_msg;
	    return (0);
	  }
	if (len == 0)
	  (*mp) = &lay_dnsqtype_msg;
	else
	  (*mp) = &lay_dnsqname_msg;
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}
