/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "layer.h"
#include "lay_data.h"
#include "lay_dataedit.h"
#include "typ_8.h"

char				*dataedit_itmpl = "\n\
<code>\n\
<a href=\"setfield(dataedit[%i%].xx)\">%%dataedit[%i%].xx%%</a>\n\
%%0x20%%\n\
</code>\n\
";

t_field				dataedit_fields[] = 
{
  {"c",		0,	typ_char_msg,		(VOID_PTR)CHAR_C},
  {"xx",	0,	typ_char_msg,		(VOID_PTR)CHAR_XX},
  {"ooo",	0,	typ_char_msg,		(VOID_PTR)CHAR_OOO},
  NULL_FIELD
};

t_status			lay_dataedit_msg(msg,arg1,arg2)
t_msg				msg;
VOID_PTR			arg1;
VOID_PTR			arg2;
{
  t_status			status;

  switch (msg)
    {
      LAY_CLASS_GENERIC;
      LAY_NAME_ID_GENERIC(&lay_dataedit_msg,"dataedit");
      LAY_GET_FIELD_GENERIC(dataedit_fields);
      LAY_SET_FIELD_GENERIC(dataedit_fields);
      LAY_GET_FIELDS_GENERIC(dataedit_fields);
      LAY_GET_FIELD_TYP_GENERIC(dataedit_fields);
    case LAY_GET_TMPL:
      {
	LAY_GET_TMPL_ARGS(gtd,bs);
	t_hash_elt	*he;
	int		i;
	t_status	status;
	
	if (he = id_get(gtd->id,
			&lay_dataedit_msg))
	  i = (int)(he->value);
	else
	  i = 0;
	if ((i % lay_data_bytes_per_line) == 0)
	  if ((status = str_cat_str(bs->str,
				    bs->max_len,
				    "<br>")) < 0)
	    return (status);
	if ((status = itmpl_format(i,
				   dataedit_itmpl,
				   bs->str,
				   bs->max_len)) < 0)
	  return (status);
	if ((status = id_override(gtd->id,
				  &lay_dataedit_msg,
				  (VOID_PTR)(++i))) < 0)
	  return (status);
	return (0);
      }
    case LAY_OFF:
      {
	LAY_OFF_ARGS(b,off);
	
	(*off) = 1;
	return (0);
      }
    case LAY_SUB:
      {
	LAY_SUB_ARGS(b,mp);
	
	(*mp) = &lay_dataedit_msg;
	return (0);
      }
    }
  return (-ERR_NOMETHOD);
}
