/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef NBGETHOST_H
#define NBGETHOST_H	1

#include "a.h"

extern t_u32		nbgethost_timeout;

/* PROTO nbgethost.c */
/* nbgethost.c */
t_status nbgethost_init P((void));
t_status nbgethost_destroy_inaddr_walk P((t_hash_elt *he, void *unused));
void nbgethost_destroy P((void));
void sigalrm P((int unused));
struct hostent *nbgethostbyname P((char *name));
struct hostent *nbgethostbyaddr P((char *addr, int addrlen, int family));
t_status inaddr_from_str_alarm P((char *str, struct in_addr *mba_inaddr, t_boolean resolve));
t_status inaddr_to_str_alarm P((struct in_addr *mba_inaddr, char *str, int max_len, t_boolean resolve));
#endif
