/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_UDP_H
#define LAY_UDP_H	1

#include "layer.h"

typedef struct		s_udp
{
  t_u16			sport;
  t_u16			dport;
  t_u16			ulen;
  t_u16			sum;
} t_udp;

#define UDP_HLEN	8
#define UDP_ALEN	4

/*
** - packet len is IP_HLEN + UDP_HLEN + data_len
** - sport + dport are unsigned short
*/

#define LAYER_UDP_CHECK(udppar,bufpar,lenpar) \
	if ((lenpar) < UDP_HLEN)\
		return (-ERR_TRUNC);\
	(udppar) = (t_udp *)(bufpar);

extern t_boolean	lay_udp_perform_sum;
extern t_boolean	lay_udp_guess_mode;
extern t_id		*lay_udp_sub_id;

/* PROTO lay_udp.c */
/* lay_udp.c */
t_status lay_udp_init P((void));
void lay_udp_destroy P((void));
t_u16 udp_cksum P((struct s_ip *ip));
int udp_compute_sum P((struct s_ip *ip));
void udp_set_proto P((t_ip *ip));
void udp_set_sport P((t_udp *udp, int sport));
int udp_get_sport P((t_udp *udp));
void udp_set_dport P((t_udp *udp, int dport));
int udp_get_dport P((t_udp *udp));
void udp_set_ulen P((t_udp *udp, int ulen));
int udp_get_ulen P((t_udp *udp));
void udp_set_sum P((t_udp *udp, int sum));
int udp_get_sum P((t_udp *udp));
t_status udp_sub P((char *buf, int len, t_msg_proc *sub_mp));
t_status udp_sum P((char *buf, int len, char *up_buf, int up_len));
t_status udp_zero_sum P((char *buf, int len, char *up_buf, int up_len));
t_status udp_adapt_len P((char *buf, int len));
t_status lay_udp_msg P((t_msg msg, void *arg1, void *arg2));
#endif
