/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_MSG_H
#define LAY_MSG_H	1

#include "layer.h"

typedef struct		s_sum_data
{
  t_buf			b;
  t_buf			up;
} t_sum_data;

typedef struct		s_summarize_data
{
  t_buf			b;
  t_bridled_str		bs;
  t_boolean		resolve;
} t_summarize_data;

typedef struct		s_get_field_data
{
  t_id			*optional_id;
  t_buf			b;
  char			*field;
} t_get_field_data;

typedef struct		s_get_field_typ_data
{
  t_msg_proc		mp;
  VOID_PTR		data;
} t_get_field_typ_data;

typedef struct		s_get_tmpl_data
{
  t_id			*id;
  t_buf			b;
} t_get_tmpl_data;

typedef struct		s_has_opt_data
{
  t_boolean		has_opt;
  t_off			opt_off;
  int			opt_len;
  t_msg_proc		opt_mp;
} t_has_opt_data;

typedef struct		s_sub_id_data
{
  t_buf			b;
  t_id			*id;
} t_sub_id_data;

#define LAY_CLASS_GENERIC	\
case MSG_CLASS:\
{\
  MSG_CLASS_ARGS(unused,classbs);\
  \
  return (lay_class_generic(classbs));\
}

#define LAY_NAME			2
#define LAY_NAME_ARGS(OptionalId,BridledStr)	\
     ARG1(t_id *,OptionalId);\
     ARG2(t_bridled_str *,BridledStr)

#define LAY_NAME_GENERIC(Name) \
case LAY_NAME:\
{\
   LAY_NAME_ARGS(unused,bs);\
\
   return (lay_name_generic(bs,\
			    (Name)));\
}

#define LAY_NAME_ID_GENERIC(Chan,Name) \
case LAY_NAME:\
{\
   LAY_NAME_ARGS(id,bs);\
\
   return (lay_name_id_generic(id,\
			       bs,\
			       (Chan),\
			       (Name)));\
}

#define LAY_OFF				3
#define LAY_OFF_ARGS(Buf,OffPtr)	\
     ARG1(t_buf *,Buf);\
     ARG2(t_off *,OffPtr)

#define LAY_SUB				4
#define LAY_SUB_ARGS(Buf,MsgProcPtr)	\
     ARG1(t_buf *,Buf);\
     ARG2(t_msg_proc *,MsgProcPtr)

#define LAY_SUM				5
#define LAY_SUM_ARGS(SumData,Unused)	\
     ARG1(t_sum_data *,SumData)

#define LAY_GET_FIELD			6
#define LAY_GET_FIELD_ARGS(GetFieldData,BridledStr)	\
     ARG1(t_get_field_data *,GetFieldData);\
     ARG2(t_bridled_str *,BridledStr)

#define LAY_GET_FIELD_GENERIC(Fields) \
case LAY_GET_FIELD:\
{\
   LAY_GET_FIELD_ARGS(gfd,bs);\
\
   return (lay_get_field_generic(gfd,\
				 bs,\
				 (Fields)));\
}

#define LAY_SET_FIELD			7
#define LAY_SET_FIELD_ARGS(GetFieldData,Value)	\
     ARG1(t_get_field_data *,GetFieldData);\
     ARG2(char *,Value)

#define LAY_SET_FIELD_GENERIC(Fields) \
case LAY_SET_FIELD:\
{\
  LAY_SET_FIELD_ARGS(gfd,str);\
\
  return (lay_set_field_generic(gfd,\
				str,\
				(Fields)));\
}

#define LAY_GET_FIELDS			8
#define LAY_GET_FIELDS_ARGS(Buf,VecStr) \
     ARG1(t_buf *,Buf);\
     ARG2(t_vec *,VecStr)

#define LAY_GET_FIELDS_GENERIC(Fields) \
case LAY_GET_FIELDS:\
{\
  LAY_GET_FIELDS_ARGS(b,vec);\
	\
  return (lay_get_fields_generic(b,\
				 vec,\
				 (Fields)));\
}

#define LAY_GET_TMPL			9
#define LAY_GET_TMPL_ARGS(GetTmplData,BridledStr)	\
     ARG1(t_get_tmpl_data *,GetTmplData);\
     ARG2(t_bridled_str *,BridledStr)

#define LAY_GET_TMPL_GENERIC(Tmpl) \
case LAY_GET_TMPL:\
{\
   LAY_GET_TMPL_ARGS(unused,bs);\
\
   return (lay_get_tmpl_generic(bs,\
				(Tmpl)));\
}

#define LAY_GET_ITMPL_GENERIC(Chan,ITmpl) \
case LAY_GET_TMPL:\
{\
   LAY_GET_TMPL_ARGS(gtd,bs);\
\
   return (lay_get_itmpl_generic(gtd,\
				 bs,\
				 (Chan),\
				 (ITmpl)));\
}

#define LAY_HAS_OPT			10
#define LAY_HAS_OPT_ARGS(Buf,HasOptData)	\
     ARG1(t_buf *,Buf);\
     ARG2(t_has_opt_data *,HasOptData)

#define LAY_ADAPT_LEN			11
#define LAY_ADAPT_LEN_ARGS(Buf,Unused)	\
     ARG1(t_buf *,Buf)

#define LAY_GET_FIELD_TYP		12
#define LAY_GET_FIELD_TYP_ARGS(GetFieldData,GetFieldTypData)	\
     ARG1(t_get_field_data *,GetFieldData);\
     ARG2(t_get_field_typ_data *,GetFieldTypData)

#define LAY_GET_FIELD_TYP_GENERIC(Fields) \
case LAY_GET_FIELD_TYP:\
{\
  LAY_GET_FIELD_TYP_ARGS(gfd,gftd);\
    \
  return (lay_get_field_typ_generic(gfd,\
				    gftd,\
				    (Fields)));\
}

#define LAY_SUB_ID			13
#define LAY_SUB_ID_ARGS(SubIdData,MsgProcPtr) \
     ARG1(t_sub_id_data *,sid);\
     ARG2(t_msg_proc *,MsgProcPtr)

/* PROTO lay_msg.c */
/* lay_msg.c */
t_status lay_msg P((t_msg_proc mp, t_msg msg, void *arg1, void *arg2));
t_status itmpl_format_do P((t_bridled_str *bs, char *var, int i));
t_status itmpl_format P((int i, char *itmpl_str, char *str, int max_len));
t_status get_field_to_str P((char *buf, int len, t_field *field, char *str, int max_len));
t_status set_field_from_str P((char *buf, int len, t_field *field, char *str));
t_status lay_name_generic P((t_bridled_str *bs, char *name));
t_status lay_name_id_generic P((t_id *optional_id, t_bridled_str *bs, void *chan, char *name));
t_status lay_get_field_generic P((t_get_field_data *gfd, t_bridled_str *bs, t_field *fields));
t_status lay_set_field_generic P((t_get_field_data *gfd, char *str, t_field *fields));
t_status lay_get_fields_generic P((t_buf *b, t_vec *vec, t_field *fields));
t_status lay_get_tmpl_generic P((t_bridled_str *bs, char *tmpl));
t_status lay_get_itmpl_generic P((t_get_tmpl_data *gtd, t_bridled_str *bs, void *chan, char *itmpl));
t_status lay_get_field_typ_generic P((t_get_field_data *gfd, t_get_field_typ_data *gftd, t_field *fields));
#endif
