/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_IEEE802_H
#define LAY_IEEE802_H	1

#include "layer.h"
#include "typ_ethaddr.h"

typedef struct		s_llc
{
  t_u8			dsap;
  t_u8			ssap;
  t_u8			cntl;
} t_llc;

#define LLC_HLEN	(sizeof (t_llc))

#define LAYER_LLC_CHECK(llcpar,bufpar,lenpar) \
	if ((lenpar) < LLC_HLEN)\
		return (-ERR_TRUNC);\
	(llcpar) = (t_llc *)(bufpar);

typedef struct		s_snap
{
  t_u8			orgcode[3];
  t_u16			type;
} t_snap;

#define SNAP_HLEN	(sizeof (t_snap))

#define LAYER_SNAP_CHECK(snappar,bufpar,lenpar) \
	if ((lenpar) < SNAP_HLEN)\
		return (-ERR_TRUNC);\
	(snappar) = (t_snap *)(bufpar);

#define LLCSAP_SNAP	0xaa

#define LLC_UI		0x03

/* PROTO lay_ieee802.c */
/* lay_ieee802.c */
t_status llc_sub P((char *buf, int len, t_msg_proc *sub_mp));
t_status lay_llc_msg P((t_msg msg, void *arg1, void *arg2));
int snap_get_type P((t_snap *snap));
t_status snap_sub P((char *buf, int len, t_msg_proc *sub_mp));
t_status lay_snap_msg P((t_msg msg, void *arg1, void *arg2));
#endif
