/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_ICMP_H
#define LAY_ICMP_H	1

#include "layer.h"
#include "lay_ip.h"

typedef struct			s_icmp
{
  t_u8				type;
  t_u8				code;
  t_u16				cksum;
} t_icmp;

#define ICMP_HLEN		(sizeof (t_icmp))

#define LAYER_ICMP_CHECK(icmppar,bufpar,lenpar) \
	if ((lenpar) < ICMP_HLEN)\
		return (-ERR_TRUNC);\
	(icmppar) = (t_icmp *)(bufpar);

#define ICMP_ECHO_REPLY			0
#define ICMP_UNREACHABLE		3
#define ICMP_SOURCE_QUENCH		4
#define ICMP_REDIRECT			5
#define ICMP_ECHO_REQUEST		8
#define ICMP_ROUTER_ADVERTISEMENT	9
#define ICMP_TIME_EXCEED		11
#define ICMP_TS_REQUEST			13
#define ICMP_TS_REPLY			14
#define ICMP_MASK_REQUEST		17
#define ICMP_MASK_REPLY			18

extern t_assoc			icmptype_assocs[];

/* PROTO lay_icmp.c */
/* lay_icmp.c */
int icmp_compute_sum P((t_ip *ip, t_icmp *icmp));
void icmp_set_proto P((t_ip *ip));
void icmp_set_type P((t_icmp *icmp, int type));
int icmp_get_type P((t_icmp *icmp));
void icmp_set_code P((t_icmp *icmp, int code));
int icmp_get_code P((t_icmp *icmp));
void icmp_set_cksum P((t_icmp *icmp, int sum));
int icmp_get_cksum P((t_icmp *icmp));
int icmp_sum P((char *buf, int len, char *up_buf, int up_len));
t_status lay_icmpmbz_msg P((t_msg msg, void *arg1, void *arg2));
t_status lay_icmpredirect_msg P((t_msg msg, void *arg1, void *arg2));
t_status lay_icmpmask_msg P((t_msg msg, void *arg1, void *arg2));
t_status lay_icmpts_msg P((t_msg msg, void *arg1, void *arg2));
int icmp_sub P((char *buf, int len, t_msg_proc *sub_mp));
t_status lay_icmp_msg P((t_msg msg, void *arg1, void *arg2));
#endif
