/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_ETHER_H
#define LAY_ETHER_H	1

#include "layer.h"
#include "typ_ethaddr.h"

typedef struct			s_ether
{
   t_u8				dhost[6];
   t_u8				shost[6];
   t_u16			type;
} t_ether;

#define ETHER_HLEN		(sizeof (t_ether))

#define LAYER_ETHER_CHECK(etherpar,bufpar,lenpar) \
	if ((lenpar) < ETHER_HLEN)\
		return (-ERR_TRUNC);\
	(etherpar) = (t_ether *)(bufpar);

#define ETHERTYPE_IP		0x800
#define ETHERTYPE_ARP		0x806
#define ETHERTYPE_RARP		0x8035
#define ETHERTYPE_ATALK		0x809b

extern t_assoc			ethertype_assocs[];

/* PROTO lay_ether.c */
/* lay_ether.c */
void ether_set_shost P((t_ether *ether, t_ether_addr *ea));
void ether_get_shost P((t_ether *ether, t_ether_addr *ea));
void ether_set_dhost P((t_ether *ether, t_ether_addr *ea));
void ether_get_dhost P((t_ether *ether, t_ether_addr *ea));
void ether_set_type P((t_ether *ether, int type));
int ether_get_type P((t_ether *ether));
t_status ether_sub P((char *buf, int len, t_msg_proc *sub_mp));
t_status lay_ether_msg P((t_msg msg, void *arg1, void *arg2));
#endif
