/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_DNS_H
#define LAY_DNS_H	1

#include "layer.h"

typedef struct		s_dns
{
  t_u16			id;
  t_u16			flags;
  t_u16			nquestions;
  t_u16			nanswers;
  t_u16			nauths;
  t_u16			nadds;
} t_dns;

#define DNS_HLEN	(sizeof (t_dns))

#define DNS_PORT	53

#define LAYER_DNS_CHECK(dnspar,bufpar,lenpar) \
	if ((lenpar) < DNS_HLEN)\
		return (-ERR_TRUNC);\
	(dnspar) = (t_dns *)(bufpar);

extern int		dns_nquestions_chan;

/* PROTO lay_dns.c */
/* lay_dns.c */
t_status dns_sub P((char *buf, int len, t_msg_proc *sub_mp));
t_status lay_dns_msg P((t_msg msg, void *arg1, void *arg2));
#endif
