/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef LAY_ARP_H
#define LAY_ARP_H	1

#include "layer.h"

typedef struct	s_arp
{
  t_u16		hrd;		/* format of hardware address */
  t_u16		pro;		/* format of protocol address */
  t_u8		hln;		/* length of hardware address */
  t_u8		pln;		/* length of protocol address */
  t_u16		op;
} t_arp;

#define ARP_HLEN	(sizeof (t_arp))

#define LAYER_ARP_CHECK(arppar,bufpar,lenpar) \
	if ((lenpar) < ARP_HLEN)\
		return (-ERR_TRUNC);\
	(arppar) = (t_arp *)(bufpar);

#define ARPHRD_ETHER 	1	/* ethernet hardware address */
#define ARPHRD_802	6	/* 802 net hardware address */

extern t_assoc		arphrd_assocs[];

#define	ARPOP_REQUEST	1	/* request to resolve address */
#define	ARPOP_REPLY	2	/* response to previous request */

extern t_assoc		arpop_assocs[];

/* PROTO lay_arp.c */
/* lay_arp.c */
void arp_set_hrd P((t_arp *arp, int hrd));
int arp_get_hrd P((t_arp *arp));
void arp_set_pro P((t_arp *arp, int pro));
int arp_get_pro P((t_arp *arp));
void arp_set_hln P((t_arp *arp, int hln));
int arp_get_hln P((t_arp *arp));
void arp_set_pln P((t_arp *arp, int pln));
int arp_get_pln P((t_arp *arp));
void arp_set_op P((t_arp *arp, int op));
int arp_get_op P((t_arp *arp));
t_status arp_sub P((char *buf, int len, t_msg_proc *sub_mp));
t_status lay_arp_msg P((t_msg msg, void *arg1, void *arg2));
#endif
