/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef A_SYSDEP_H
#define A_SYSDEP_H	1

#include "a_config.h"

#define DEBUG		1	/* debug is a feature, not an option */	
#define DEBUG_MALLOC	1	/* debug_malloc is a feature as it is
				   not mandatory */

#if defined(__osf__) && defined(__alpha) /* on alpha, force some options */
# define WITH_MG_KLUDGE	1
#endif

#ifdef WITH_MG_KLUDGE
# undef HAVE_BITFIELDS
# define HAVE_STDARG_H
#endif

#ifdef HAVE_VOID_FUNC
# define VOID_FUNC	void
#else
# define VOID_FUNC	int
#endif

#ifdef HAVE_VOID_PTR
# define VOID_PTR	void*
#else
# define VOID_PTR	char*
#endif

#ifdef HAVE_VOID_DECL
# define VOID_DECL	void
#else
# define VOID_DECL
#endif

#ifndef HAVE_BZERO
# define bzero(Ptr,Size)	memset((Ptr),0,(Size))
#endif

#ifndef HAVE_BCOPY
# define bcopy(Src,Dst,Size)	memcpy((Dst),(Src),(Size))
#endif

#ifndef HAVE_BCMP
# define bcmp(Buf1,Buf2,Size)	memcmp((Buf1),(Buf2),(Size))
#endif

#define FBCOPY(Src,Dst,Size)	bcopy((char *)(Src),(char *)(Dst),(Size))
#define FBZERO(Buf,Size)	bzero((char *)(Buf),(Size))
#define FBCMP(Buf1,Buf2,Len)	bcmp((char *)(Buf1),(char *)(Buf2),(Len))

#ifdef NO_PROTOTYPE
# define P(Prototype)	()
#else
# ifdef HAVE_PROTOTYPES
#  define P(Prototype)	Prototype
# else
#  define P(Prototype)	 ()
# endif
#endif

#ifdef HAVE_ANSI_CPP
# define QUOTE(Expr)	#Expr
#else
# define QUOTE(Expr)	""
#endif

#ifndef NULL
# define NULL		((VOID_PTR)0)
#endif

#ifndef TRUE
# define TRUE		(1==1)
#endif
#ifndef FALSE
# define FALSE		(1==0)
#endif

/*
 * types
 */

#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>

#endif

typedef signed int	t_status;
typedef int		t_boolean;
typedef unsigned long	t_off;

typedef int		t_32;			/* Natural */
typedef signed int	t_s32;			/* Signed */
typedef unsigned int	t_u32;			/* Unsigned */
typedef short		t_16;
typedef signed short	t_s16;
typedef unsigned short	t_u16;
typedef char		t_8;	
typedef signed char	t_s8;
typedef unsigned char	t_u8;
#if defined(__osf__) && defined(__alpha)
typedef long		t_64;	
typedef unsigned long	t_u64;
typedef signed long	t_s64;
#endif

#define ARRAY_COUNT(Array)	(sizeof (Array)/sizeof ((Array)[0]))
#define OFFSET(TypePtr,Field)	((t_off)(&(((TypePtr)NULL)->Field)))

/*
 * stdlib
 */

#ifdef HAVE_STDLIB_H
# include <stdlib.h>
#else
extern VOID_PTR		malloc P((size_t size));
extern VOID_PTR		realloc P((VOID_PTR ptr,size_t new_size));
extern VOID_FUNC	free P((VOID_PTR ptr));
extern int		abort P((VOID_DECL));
extern char		*getenv P((char *var));
#endif

/*
 * unistd
 */

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#else
extern char		*ttyname();
#endif

/*
 * errno
 */

#include <errno.h>

#ifdef NOTDEF
extern int		errno;
extern char		*sys_errlist[];
#endif

#ifndef HAVE_STRERROR
char			*strerror P((int errcode));
#endif

/*
 * varargs
 */

#ifdef HAVE_STDARG_H
# include <stdarg.h>
#else
# include <varargs.h>
#endif

/*
 * BUFSIZ
 */

#include <stdio.h>

/*
 * string*.h
 */

#ifdef HAVE_STRING_H
# include <string.h>
#endif
#ifdef HAVE_STRINGS_H
# include <strings.h>
#endif

#ifndef HAVE_STRDUP
char			*strdup P((char *string));
#endif

/*
 * MAXHOSTNAMELEN
 */

#include <sys/param.h>

/*
 * assert
 */

#ifdef HAVE_ASSERT_H
# include <assert.h>
#endif

#endif
