/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef A_STR_H
#define A_STR_H	1

#include "a.h"

/* A FIXED STR SIZE FOR MOST COMMON STRINGS */
#define STR_BUFSIZ	256

typedef struct		s_bridled_str
{
  int			max_len;
  char			*str;
} t_bridled_str;

/* PROTO a_str.c */
/* a_str.c */
t_status str_cat_str P((char *tostr, int max_len, char *str));
t_status str_cat_char P((char *tostr, int max_len, int c));
t_status str_cat_buf P((char *tostr, int max_len, char *buf, int len));
t_status str_cat_fmt_va P((char *tostr, int max_len, char *fmt, ...));
t_status str_cat_fmt_va_list P((char *tostr, int max_len, char *fmt, va_list args));
t_status str_cat_fmt_va_unlimited P((char *tostr, int max_len, char *fmt, ...));
#endif
