/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef A_INT_H
#define A_INT_H	1

#include "a.h"

typedef struct		s_base
{
  int			num;
  char			*str;
  char			*prefix;
} t_base;

#define BASE_HEX_CAP	(65535 + 16)

/* PROTO a_int.c */
/* a_int.c */
t_base *base_get_from_num P((int num));
t_status ulong_to_str_i P((unsigned long num, t_base *base, char *str, int max_len));
t_status long_to_str_i P((signed long num, t_base *base, char *str, int max_len));
t_status ulong_to_str P((unsigned long num, int basenum, char *str, int max_len));
t_status long_to_str P((signed long num, int basenum, char *str, int max_len));
t_status long_from_str P((char *str, int *basenum, signed long *num));
t_status ulong_from_str P((char *str, int *basenum, unsigned long *num));
#endif
