/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef A_ERR_H
#define A_ERR_H	1

#include "a.h"

#define ERR_MAGICSYS		32768
#define ERR_SYS(status)		((status) > ERR_MAGICSYS)

#define ERR_UNDEFINED		1
#define ERR_EXIST		2
#define ERR_ALIGN		3
#define ERR_NOMEM		(ERR_MAGICSYS + 4)
#define ERR_NOENT		5
#define ERR_BO			6
#define ERR_BADFMT		7
#define ERR_READ		(ERR_MAGICSYS + 8)
#define ERR_INVAL		9
#define ERR_NOTDYN		10
#define ERR_SYNTAX		11
#define ERR_PAREN		12
#define ERR_NI			13
#define ERR_BADMATCH		14
#define ERR_BRACE		15
#define ERR_NOTDIGIT		16
#define ERR_TRAILBSLASH		17
#define ERR_NOTAFUNC		18
#define ERR_TRUNC		19
#define ERR_NOMETHOD		20
#define ERR_MALFORMED		21
#define ERR_UNRESOLVABLE	22
#define ERR_TOOMANY		23
#define ERR_NEEDMORE		24
#define ERR_CANTGOON		25
#define ERR_OPEN		(ERR_MAGICSYS + 26)
#define ERR_SYSCALL		(ERR_MAGICSYS + 27)
#define ERR_WRITE		(ERR_MAGICSYS + 28)
#define ERR_BADARGS		29
#define ERR_NEEDEQUAL		30
#define ERR_NEEDMOREDATA	31
#define ERR_NOSUCHVAR		32
#define ERR_TOOMUCHDATA		33
#define ERR_BADARGTYPE		34
#define ERR_NOSUCHFIELD		35
#define ERR_NOSUCHKEY		36
#define ERR_PARSE		37
#define ERR_DIVBYZERO		38
#define ERR_NOMATCH		39
#define ERR_BADBSLASH		40
#define ERR_BADVEC		41
#define ERR_INUSE		42
#define ERR_SUBROUTINE		43
#define ERR_ZEROLEN		44
#define ERR_UNPREDICTABLE	45
#define ERR_BADLEN		46
#define ERR_BADELT		47
#define ERR_BADID		48
#define ERR_EMPTY		49
#define ERR_BADEVENT		50
#define ERR_TOOBIG		51
#define ERR_BADCLASS		52
#define ERR_HOLE		53
#define ERR_BADCOUNT		54
#define ERR_NOTINITED		55
#define ERR_NOTFOUND		56
#define ERR_MISSINGVAR		57
#define ERR_BREAK		58
#define ERR_ROOT		59
#define ERR_PARENTISCHILD	60
#define ERR_IDENTICAL		61
#define ERR_NOSUCHPROP		62
#define ERR_NOPROP		63
#define ERR_NOROOM		64
#define ERR_BADSLOT		65
#define ERR_NOCHOICE		66
#define ERR_CANTREPLY		67
#define ERR_BADHEADER		68
#define ERR_LOOP		69
#define ERR_NOTCAPABLE		70
#define ERR_MISSPARAM		71
#define ERR_SOCKET		(ERR_MAGICSYS + 72)
#define ERR_NOSUCHPARAM		73
#define ERR_NOSUCHFAMILY	74
#define ERR_NOSUCHMEMBER	75	
#define ERR_NEEDUNICITY		76
#define ERR_BADOPTION		77
#define ERR_ALREADY		78
#define ERR_BADOPCODE		79
#define ERR_ACCESS		(ERR_MAGICSYS + 80)
#define ERR_INTERNAL		81
#define ERR_CANTHANDLE		82
#define ERR_NOSUCHBASE		83
#define ERR_CHANINUSE		84
#define ERR_BADSZ		85
#define ERR_UNRECOGBASE		86
#define ERR_BADADDR		87

/* PROTO a_err.c */
/* a_err.c */
char *err_msg P((t_status errcode));
void err_print P((int errcode, char *fmt, ...));
#endif
