/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef A_BIT_H
#define A_BIT_H		1

#include "a.h"

#define BIT_SET(u,n)		((u) |= (1 << (n)))
#define BIT_ISSET(u,n)		((u) & (1 << (n)))

typedef struct		s_bit_field
{
  int			from;
  int			to;
} t_bit_field;

/* PROTO a_bit.c */
/* a_bit.c */
t_u8 *bit_field_u8_get P((t_u8 *valp, int from, int to));
t_u16 *bit_field_u16_get P((t_u16 *valp, int from, int to));
t_u32 *bit_field_u32_get P((t_u32 *valp, int from, int to));
void bit_field_u8_set P((t_u8 *valp, int from, int to, int value));
void bit_field_u16_set P((t_u16 *valp, int from, int to, int value));
void bit_field_u32_set P((t_u32 *valp, int from, int to, int value));
void bit_print_u8 P((t_u8 *valp));
void bit_print_u16 P((t_u16 *valp));
void bit_print_u32 P((t_u32 *valp));
#endif
