/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"

/* catenates a string to a string.
   Tostr must be a valid string.
   Returns 0 if OK, -ERR_BO on buffer overflows */
t_status	str_cat_str(tostr,max_len,str)
char		*tostr;
int		max_len;
char		*str;
{
  int		tostr_len;
  int		str_len;

  tostr_len = strlen(tostr);
  str_len = strlen(str);
  if ((tostr_len + str_len + 1) > max_len)
    return (-ERR_BO);
  strcpy(tostr + tostr_len,str);
  return (0);
}

/* catenates a char to a string.
   Tostr must be a valid string.
   Returns 0 if OK, -ERR_BO on buffer overflows */
t_status	str_cat_char(tostr,max_len,c)
char		*tostr;
int		max_len;
int		c;
{
  int		tostr_len;
  
  tostr_len = strlen(tostr);
  if ((tostr_len + 1) > max_len)
    return (-ERR_BO);
  tostr[tostr_len] = c;
  tostr[tostr_len + 1] = 0;
  return (0);
}

/* catenates a buffer to a string.
   Tostr must be a valid string. Note that there is no check of an
   eventual zero in buffer. It calls str_cat_char(3).
   Returns 0 if OK, -ERR_BO on buffer overflows */
t_status	str_cat_buf(tostr,max_len,buf,len)
char		*tostr;
int		max_len;
char		*buf;
int		len;
{
  int		i;
  t_status	status;

  i = 0;
  while (i < len)
    {
      if ((status = str_cat_char(tostr,max_len,buf[i])) <0)
	return (status);
      i++;
    }
  return (0);
}

/* catenates a printf(3) format to a string.
   Tostr must be a valid string. Result of format must no exceed BUFSIZ bytes 
   minus the previous len of tostr. Check str_cat_fmt_va_unlimited for 
   a unlimited version of this function. 
   Returns 0 if OK, -ERR_BO on buffer overflows */
#ifdef HAVE_STDARG_H
t_status	str_cat_fmt_va(char *tostr,
			       int max_len,
			       char *fmt,...)
#else
t_status	str_cat_fmt_va(tostr,max_len,fmt,va_alist)
char		*tostr;
int		max_len;
char		*fmt;
va_dcl
#endif
{
  va_list	ap;
  char		buf[BUFSIZ];
  int		status;
  int		tostr_len;

  tostr_len = strlen(tostr);
  if (fmt != NULL)
    {
#ifdef HAVE_STDARG_H
      va_start(ap,fmt);
#else
      va_start(ap);
#endif
      vsnprintf(buf,BUFSIZ - tostr_len,fmt,ap);
      status = str_cat_str(tostr,max_len,buf);
    }
  else
    status = -ERR_BADFMT;
  va_end(ap);
  return (status);
}

/* catenates a printf(3) format under a form of va_list to a string.
   Tostr must be a valid string. Result of format must no exceed BUFSIZ bytes 
   minus the previous len of tostr.
   Returns 0 if OK, -ERR_BO on buffer overflows */
t_status	str_cat_fmt_va_list(tostr,max_len,fmt,args)
char		*tostr;
int		max_len;
char		*fmt;
va_list		args;
{
  char		buf[BUFSIZ];
  int		status;
  int		tostr_len;

  tostr_len = strlen(tostr);
  if (fmt != NULL)
    {
      vsnprintf(buf,BUFSIZ - tostr_len,fmt,args);
      status = str_cat_str(tostr,max_len,buf);
    }
  else
    status = -ERR_BADFMT;
  return (status);
}


/* catenates a printf(3) format to a string.
   Tostr must be a valid string. 
   We should have replace str_cat_fmt_va(3) by this function but we
   have hesitated because of the possible implications.
   Returns 0 if OK, -ERR_BO on buffer overflows */
#ifdef HAVE_STDARG_H
t_status	str_cat_fmt_va_unlimited(char *tostr,
					 int max_len,
					 char *fmt,...)
#else
t_status	str_cat_fmt_va_unlimited(tostr,max_len,fmt,va_alist)
char		*tostr;
int		max_len;
char		*fmt;
va_dcl
#endif
{
  va_list	ap;
  int		status;
  int		tostrlen;
  
  tostrlen = strlen(tostr);
  if (fmt != NULL)
    {
#ifdef HAVE_STDARG_H
      va_start(ap,fmt);
#else
      va_start(ap);
#endif
      vsnprintf(tostr + tostrlen,max_len - tostrlen,fmt,ap);
      status = 0;
    }
  else
    status = -ERR_BADFMT;
  va_end(ap);
  return (status);
}
