/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"

/* pushes an elt in a stack.
   Note that it could be a macro because it simply calls vec_add(3).
   Returns the position in the stack if positive, an error if negative */
int		stack_push(stack,elt)
t_vec		*stack;
VOID_PTR	elt;
{
  return (vec_add(stack,elt));
}

/* lookups an elt in the stack.
   Returns 0 if OK (and fills *elt), return -ERR_NOENT is stack is empty */
t_status	stack_lookup(stack,elt)
t_vec		*stack;
VOID_PTR	*elt;		/* Pointer to an opaque elt */
{
  if (VEC_COUNT(stack) == 0)
    return (-ERR_NOENT);
  else
    {
      (*elt) = VEC_LAST_ELT(stack);
      return (0);
    }
}

/* pops an elt in the stack.
   Returns the same values as stack_lookup(3) */
t_status	stack_pop(stack,elt)
t_vec		*stack;
VOID_PTR	*elt;		/* Pointer to an opaque elt */
{
  t_status	status;

  if ((status = stack_lookup(stack,elt)) == 0)
    {
      VEC_RM_LAST_ELT(stack);
      return (0);
    }
  return (status);
}
