/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <ctype.h>
#include "a.h"

/* converts a string to a boolean value.
   Returns TRUE if str matches "true" (case insensitive), FALSE otherwise. */
t_boolean		atobooleanfalse(str)
char			*str;
{
  if (!strcasecmp(str,"true"))
    return (TRUE);
  return (FALSE);
}

/* converts a string to a boolean value.
   Returns FALSE if str matches "false" (case insensitive), TRUE otherwise. */
t_boolean		atobooleantrue(str)
char			*str;
{
  if (!strcasecmp(str,"false"))
    return (FALSE);
  return (TRUE);
}

/* allocates memory in a pool (a vector of pointers).
   Pool must pre-exist.
   Return a pointer to a memory zone or NULL */
VOID_PTR		pool_alloc(pool,
				   alloc_proc,
				   size,
				   comment,
				   free_proc,
				   status)
t_vec			*pool;			/* The pool */
t_alloc_proc		alloc_proc;		/* Alloc. method */
size_t			size;			/* Size requested */
char			*comment;		/* Major comment */
t_free_proc		free_proc;		/* Free method */
t_status		*status;		/* Filled if NULL */
{
  VOID_PTR		ptr;

  if ((ptr = alloc_proc(size,
			comment,
			"pool_alloc:ptr",
			status)) == NULL)
    return (NULL);
  if (((*status) = vec_add(pool,ptr)) < 0)
    {
      free_proc(ptr,
		comment,
		"pool_alloc:ptr");
      return (NULL);
    }
}

/* duplicates a string.
   Returns a new string or NULL if failed. */
char			*strdup_alloc(str,alloc_proc,comment1,comment2,status)
char			*str;		/* The reference string */	
t_alloc_proc		alloc_proc;	/* The alloc method */
char			*comment1;	/* The major comment */
char			*comment2;	/* The minor comment */
t_status		*status;	/* Filled if NULL */	
{
  char			*nstr;
  int			len;

  len = strlen(str);
  if ((nstr = alloc_proc((len + 1) * sizeof (char),
			 comment1,
			 comment2,
			 status)) == NULL)
    return (NULL);
  strcpy(nstr,str);
  return (nstr);
}

/* skips bytes matching chars. */
char			*str_skip(str,chars)
char			*str;
char			*chars;
{
  while (*str)
    {
      if (!index(chars,*str))
        return (str);
      str++;
    }
  return (NULL);
}

/* finds first byte in str matching chars */
char			*str_find(str,chars)
char			*str;
char			*chars;
{
  while (*str)
    {
      if (index(chars,*str))
        return (str);
      str++;
    }
  return (NULL);
}

/* buffer version of index(3). */
char			*bindex(buf,len,c)
char			*buf;
int			len;
int			c;
{
  int			i;

  i = 0;
  while (i < len)
    {
      if (buf[i] == c)
	return (buf + i);
      i++;
    }
  return (NULL);
}

/* counts the occurences of c in str */
int			indexcount(str,c)
char			*str;
int			c;
{
  int			count;

  count = 0;
  while (*str)
    {
      if ((*str) == c)
	count++;
      str++;
    }
  return (count);
}

/* destructive-lowercase of str */
VOID_FUNC		str_lower(str)
char			*str;
{
  while (*str)
    {
      if (isupper(*str))
	*str = tolower(*str);
      str++;
    }
}

#ifdef DEBUG
/* initializes debug features of liba.
   This is a debug function. */
VOID_FUNC		a_debug_init(VOID_DECL)
{
  /* NOP FOR THE MOMENT */
}

/* fills a buffer with 0xff.
   This is a debug function */
VOID_FUNC		bff(buf,len)
char			*buf;
int			len;
{
  int			i;

  i = 0;
  while (i < len)
    {
      buf[i] = 0xff;
      i++;
    }
}
#endif
