/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"

#ifndef NBBY
# define NBBY	8
#endif 

#define BITFIELDGET(Proc,Type) \
Type		*Proc(valp,from,to)\
Type		*valp;\
int		from;\
int		to;\
{\
  static Type	staticval;\
\
  staticval = *valp;\
  staticval <<= from;\
  staticval >>= from;\
  staticval >>= (((sizeof (Type) * NBBY) - 1) - to);\
  return (&staticval);\
}

#define BITFIELDSET(Proc,Type) \
VOID_FUNC	Proc(valp,from,to,value)\
Type		*valp;\
int		from;\
int		to;\
int		value;\
{\
  Type		val;\
  int		nbits;\
  Type		mask;\
\
  nbits = to - from;\
  val = *valp;\
  mask = ~0;\
  value <<= (((sizeof (Type) * NBBY) - 1) - nbits);\
  mask <<= (((sizeof (Type) * NBBY) - 1) - nbits);\
  value >>= (((sizeof (Type) * NBBY) - 1) - nbits);\
  mask >>= (((sizeof (Type) * NBBY) - 1) - nbits);\
  value <<= (((sizeof (Type) * NBBY) - 1) - to);\
  mask <<= (((sizeof (Type) * NBBY) - 1) - to);\
  mask = ~mask;\
  val &= mask;\
  val |= value;\
  *valp = val;\
}

/* extracts or insert bitfield values delimited by "from" and "to".
   Note: "From" is starting from 0. The first bit is designed as [0,0].
   "Value" must not override its range (2^(from-to)) because there is no
   guarantee of the result (I've tried to shift bits on the left to lose
   their values but it doesn't work: some help here will be very apprecied).

   Warning: It doesn't deal with alignment (for sizes > 8). */

BITFIELDGET(bit_field_u8_get,t_u8)
BITFIELDGET(bit_field_u16_get,t_u16)
BITFIELDGET(bit_field_u32_get,t_u32)

BITFIELDSET(bit_field_u8_set,t_u8)
BITFIELDSET(bit_field_u16_set,t_u16)
BITFIELDSET(bit_field_u32_set,t_u32)
