/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"

/* adds a buffer to an array of char.
   The memory is of course allocated according to the strategy.
   Returns 0 or various errors */
t_status		arr_char_add_buf(arr,buf,len)
t_arr			*arr;		/* Array of char	*/
char			*buf;
int			len;
{
  t_status		status;

  if (arr->allocated < (arr->count + len))
    if ((status = arr_alloc(arr,arr->count + len)) < 0)
      return (status);
  bcopy(buf,ARR_CHAR_BUF(arr) + arr->count * arr->eltsize,len); 
  arr->count += len;
  return (0);
}

/* adds zeros to an arrays of char.
   It adds len zeros to the array.
   Returns 0 or various errors */
t_status		arr_char_add_zeros(arr,len)
t_arr			*arr;
int			len;		/* Number of zeros to add	*/
{
  t_status		status;
  int			i;

  if (arr->allocated < (arr->count + len))
    if ((status = arr_alloc(arr,arr->count + len)) < 0)
      return (status);
  bzero(ARR_CHAR_BUF(arr) + arr->count * arr->eltsize,len); 
  arr->count += len;
  return (0);
}

/* "extracts" a buffer from the array.
   Discards the off first bytes of the array.
   Returns 0 or various errors */
t_status		arr_char_extract_from(arr,off)
t_arr			*arr;
t_off			off;
{
  int			new_count;

  if ((new_count = arr->count - off) < 0)
    return (-ERR_TRUNC);
  bcopy(ARR_CHAR_BUF(arr) + off * arr->eltsize,
	ARR_CHAR_BUF(arr),
	new_count);
  arr->count = new_count;
  return (0);
}
