/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * Copyright Olivier Raoul (C) 1995
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#if XtSpecificationRelease > 4
# include <X11/Xmu/Editres.h>
#endif
#include "xt_macro.h"
#include "xmg_i.h"

t_vec		*xt_macro_widget_stack = NULL;

/* initalizes the widget stack.
   
   See also: XtMacro package from the internet, copyright Olivier Raoul */
t_status	xt_macro_init(VOID_DECL)
{
  t_status	status;

  if ((xt_macro_widget_stack = XMG_VEC_NEW(&status)) == NULL)
    return (status);
  return (0);
}

/* destroys the widget stack. */
VOID_FUNC	xt_macro_destroy(VOID_DECL)
{
  vec_delete(xt_macro_widget_stack);
}

#ifdef HAVE_STDARG_H
VOID_FUNC	xt_macro_push_child(Widget w,...)
#else
VOID_FUNC	xt_macro_push_child(w,va_alist)
Widget		w;
va_dcl
#endif
{
  t_status	status;

  if ((status = stack_push(xt_macro_widget_stack,w)) < 0)
    {
      err_print(-status,"stack_push");
      exit(1);
    }
}

Widget		xt_macro_lookup_child(VOID_DECL)
{
  t_status	status;
  Widget	w;	

  if ((status = stack_lookup(xt_macro_widget_stack,(VOID_PTR *)(&w))) < 0)
    {
      err_print(-status,"stack_lookup");
      exit(1);
    }
  return (w);
}

VOID_FUNC	xt_macro_pop_child(VOID_DECL)
{
  t_status	status;
  Widget	w;	

  if ((status = stack_pop(xt_macro_widget_stack,(VOID_PTR *)(&w))) < 0)
    {
      err_print(-status,"stack_pop");
      exit(1);
    }
}

#ifndef PROGRAM_CPROTO
int		xt_macro_nothing()
{
  return (0);
}
#endif

Widget			xt_macro_va_create_widget(f,name,widget_class,
						  parent,var,count)
Widget			(*f)();
String			name;
WidgetClass		widget_class;
Widget			parent;
va_list			var;
int			count;
{
  Widget		widget;
  VOID_PTR		typed_args;
  Cardinal		num_args;
    
  typed_args = NULL;
  _XtVaToTypedArgList(var,count,&typed_args,&num_args);
  widget = (*f)(name,widget_class,parent,(ArgList)NULL, 
		(Cardinal)0,typed_args,num_args);
  if (typed_args != NULL)
    {
      XtFree((XtPointer)typed_args);
    }    
    return (widget);
}

#ifdef HAVE_STDARG_H
Widget		xt_macro_create_widget(char *name,
				       WidgetClass widget_class,
				       ...)
#else
Widget		xt_macro_create_widget(name,widget_class,va_alist)
char		*name;
WidgetClass	widget_class;
va_dcl
#endif
{
  va_list	var;
  Widget	widget;
  int		total_count;
  int		typed_count;

#ifdef DEBUG
  if (XMG_VERB(VERB_XT_MACRO))
    fprintf(stderr,"widget %s\n",name);
#endif  
#ifdef HAVE_STDARG_H
  va_start(var,widget_class);
#else
  va_start(var);
#endif
  _XtCountVaList(var,&total_count,&typed_count);
  va_end(var);
#ifdef HAVE_STDARG_H
    va_start(var,widget_class);
#else
    va_start(var);
#endif
    if (XtIsSubclass(xt_macro_lookup_child(),compositeWidgetClass) == False)
      {
	err_print(1,"xt_macro_create_widget","",
		  "Warning: widget `%s' is not a composite",
		  XtName(xt_macro_lookup_child()));
	return (NULL);
      }
    widget = xt_macro_va_create_widget(_XtCreateWidget,
				       name,
				       widget_class, 
				       xt_macro_lookup_child(),
				       var,
				       total_count);
    xt_macro_push_child(widget);
    XtManageChild(widget);
    va_end(var);
    return (widget);
}

#ifdef HAVE_STDARG_H
Widget			xt_macro_create_shell_widget(char *name,
						     WidgetClass widget_class,
						     ...)
#else
Widget			xt_macro_create_shell_widget(name,
						     widget_class,
						     va_alist)
char			*name;
WidgetClass		widget_class;
va_dcl
#endif
{
    va_list		var;
    Widget		widget;
    int		 	total_count;
    int			typed_count;
    
#ifdef DEBUG
  if (XMG_VERB(VERB_XT_MACRO))
    fprintf(stderr,"shell %s\n",name);
#endif  
#ifdef HAVE_STDARG_H
    va_start(var,widget_class);
#else
    va_start(var);
#endif
    _XtCountVaList(var,&total_count,&typed_count);
    va_end(var);
#ifdef HAVE_STDARG_H
    va_start(var,widget_class);
#else
    va_start(var);
#endif
    widget = xt_macro_va_create_widget(_XtCreatePopupShell,
				       name,
				       widget_class,
				       xt_macro_lookup_child(),
				       var,
				       total_count);
    xt_macro_push_child(widget);
    va_end(var);
    return (widget);
}

#ifdef HAVE_STDARG_H
Widget		xt_macro_app_initialize(XtAppContext *app_context_return,
					String application_class,
					XrmOptionDescList options,
					Cardinal num_options,
					int *argc_in_out,
					String *argv_in_out,
					String *fallback_resources,
					...)
#else
Widget			xt_macro_app_initialize(app_context_return,
						application_class,
						options,
						num_options,
						argc_in_out,
						argv_in_out,
						fallback_resources,
						va_alist);
XtAppContext		*app_context_return,
String			application_class,
XrmOptionDescList	options,
Cardinal		num_options,
int			*argc_in_out,
String			*argv_in_out,
String			*fallback_resources,
va_dcl
#endif
{
  va_list		var;
  Widget		widget;
  int			total_count;
  int			typed_count;
  
#ifdef DEBUG
  if (XMG_VERB(VERB_XT_MACRO))
    fprintf(stderr,"app %s\n",application_class);
#endif  
#ifdef HAVE_STDARG_H
  va_start(var,fallback_resources);
#else
  va_start(var);
#endif
  _XtCountVaList(var,&total_count,&typed_count);
  va_end(var);
#ifdef HAVE_STDARG_H
  va_start(var,fallback_resources);
#else
  va_start(var);
#endif
  widget = XtAppInitialize(app_context_return,
			   application_class,
			   options,
			   num_options,
			   argc_in_out,
			   argv_in_out,
			   fallback_resources,
#if defined(__osf__) && defined(__alpha)
			   (ArgList)(var._a0),
#else
			   (ArgList)var,
#endif
			   total_count);
#if XtSpecificationRelease>4  
  XtAddEventHandler(widget,(EventMask)0,TRUE,_XEditResCheckMessages,NULL);
#endif
  xt_macro_push_child(widget);
  va_end(var);
  return (widget);
}

VOID_FUNC		xt_macro_method_process_callback(src,md,p)
Widget			src;
t_method_data		*md;
XtPointer		p;
{
  XtArgVal		val;
  
  XtVaGetValues(src,md->src_res,&val,NULL);
  XtVaSetValues(md->dst,md->dst_res,val,NULL);
}

VOID_FUNC		xt_macro_trace_process_callback(src,td,p)
Widget			src;
t_trace_data		*td;
XtPointer		p;
{
  XtVaGetValues(src,
		td->res,
		td->var,
		NULL);
}

VOID_FUNC		xt_macro_method_destroy_callback(src,md,p)
Widget			src;
t_method_data		*md;
XtPointer		p;
{
  XMG_FREE_PROC(md,
		"",
		"*:md");
}

VOID_FUNC		xt_macro_do_method(src,callback,src_res,dst,dst_res)
Widget			src;
String			callback;
String			src_res;
Widget			dst;
String			dst_res;
{
  t_method_data		*md;
  t_status		status;

  if ((md = XMG_ALLOC_PROC(sizeof (t_method_data),
			   "",
			   "xt_macro_do_method:md",
			   &status)) == NULL)
    {
      err_print(-status,"XMG_ALLOC_PROC");
      exit(1);
    }
  md->dst = dst;
  md->src_res = src_res;
  md->dst_res = dst_res;
  XtAddCallback(src,
		callback,
		(XtCallbackProc)xt_macro_method_process_callback,
		md);
  XtAddCallback(src,
		XtNdestroyCallback,
		(XtCallbackProc)xt_macro_method_destroy_callback,
		md);
}

VOID_FUNC		xt_macro_do_method_double(src,
						  callback,
						  src_res,
						  dst,
						  dst_res)
Widget			src;
String			callback;
String			src_res;
Widget			dst;
String			dst_res;
{
  xt_macro_do_method(src,callback,src_res,dst,dst_res);
  xt_macro_do_method(dst,callback,src_res,src,dst_res);
}

VOID_FUNC		xt_macro_do_method_trace(src,callback,res,var)
Widget			src;
String			callback;
String			res;
XtPointer		var;
{
  t_trace_data		*td;
  t_status		status;

  if ((td = XMG_ALLOC_PROC(sizeof (t_trace_data),
			   "",
			   "xt_macro_do_method_trace:td",
			   &status)) == NULL)
    {
      err_print(-status,"XMG_ALLOC_PROC");
      exit(1);
    }
  td->res = res;
  td->var = var;
  XtAddCallback(src,
		callback,
		(XtCallbackProc)xt_macro_trace_process_callback,
		td);
  XtAddCallback(src,
		XtNdestroyCallback,
		(XtCallbackProc)xt_macro_method_destroy_callback,
		td);
}

VOID_FUNC		xt_macro_mcallback_callback(w,md,cbs)
Widget			w;
t_multi_data		*md;
XtPointer		cbs;
{
  md->proc(w,md->args,cbs);
}

VOID_FUNC		xt_macro_mdestroy_callback(w,md)
Widget			w;
t_multi_data		*md;
{
  vec_delete(md->args);
  XMG_FREE_PROC(md,
		"",
		"*:md");
}


#ifdef HAVE_STDARG_H
VOID_FUNC		xt_macro_add_mcallback(char *name,
					       XmgMCallbackProc proc,
					       ...)
#else
VOID_FUNC		xt_macro_add_mcallback(name,proc,va_alist)
char			*name;
XmgMCallbackProc	proc;
va_dcl
#endif
{
  va_list		ap;
  t_multi_data		*md;
  t_status		status;
  VOID_PTR		ptr;

#ifdef HAVE_STDARG_H
  va_start(ap,proc);
#else
  va_start(ap);
  va_arg(ap,char *);
  va_arg(ap,XmgMcallbackProc);
#endif
  if ((md = XMG_ALLOC_PROC(sizeof (t_multi_data),
			   "",
			   "xt_macro_add_mcallback:md",
			   &status)) == NULL)
    {
      err_print(-status,"XMG_ALLOC_PROC");
      exit(1);
    }
  if ((md->args = XMG_VEC_NEW(&status)) == NULL)
    {
      err_print(-status,"XMG_VEC_NEW");
      exit(1);
    }
  md->proc = proc;
  while (ptr = va_arg(ap,VOID_PTR))
    {
      if ((status = vec_add(md->args,ptr)) < 0)
	{
	  err_print(-status,"vec_add");
	  exit(1);
	}
    }
  va_end(ap);
  XtAddCallback(GETPARENT,
		name,
		(XtCallbackProc)xt_macro_mcallback_callback,
		md);
  XtAddCallback(GETPARENT,
		XtNdestroyCallback,
		(XtCallbackProc)xt_macro_mdestroy_callback,
		md);
}
