/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "xmg_i.h"

#ifdef DEBUG
t_mask			xmg_verb_level;

t_mask_def		xmg_verb_level_defs[] = 
{
  {"xt_macro",		VERB_XT_MACRO},
  {"cvt",		VERB_CVT},
  {"fancy",		VERB_FANCY},
  {"all",		~0L},
  {NULL,		0}
};

/* initializes the Xmg debug env. 
   This is a debug function */
VOID_FUNC		xmg_debug_init(VOID_DECL)
{
  char			*str;

  if (str = getenv("XMG_VERB_LEVEL"))
    {
      t_vec		*vec;
      t_status		status;

      vec = XMG_VEC_NEW(&status);
      assert(vec);
      if ((status = vec_str_split(vec,str,'|')) < 0)
	{
	  err_print(-status,"xmg_debug_init");
	  abort();
	}
      if ((status = mask_from_vec_str(xmg_verb_level_defs,
				      vec,
				      &xmg_verb_level)) < 0)
	{
	  err_print(-status,"xmg_debug_init");
	  abort();
	}
      vec_str_delete(vec);
    }
}
#endif
