/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef XMG_I_H
#define XMG_I_H	1

#include "a.h"

#ifndef _Xconst
# define _Xconst
#endif

#ifdef DEBUG_MALLOC
# include "gdm.h"
# define XMG_ALLOC_ALGORITHM	gdm_alloc_algorithm
# define XMG_ALLOC_PROC		gdm_alloc
# define XMG_REALLOC_PROC	gdm_realloc
# define XMG_FREE_PROC		gdm_free
#else
# define XMG_ALLOC_ALGORITHM	alloc_algorithm_factor2
# define XMG_ALLOC_PROC		alloc_malloc
# define XMG_REALLOC_PROC	realloc_realloc
# define XMG_FREE_PROC		free_free
#endif

#define XMG_VEC_NEW(statusp)	vec_new(VEC_BASE,\
					FALSE,\
					XMG_ALLOC_ALGORITHM,\
					XMG_ALLOC_PROC,\
					XMG_REALLOC_PROC,\
					XMG_FREE_PROC,\
					"xmg_vec",\
					(statusp))

#define XMG_VEC_ONE_NEW(statusp)	vec_new(VEC_ONE_BASE,\
					FALSE,\
					XMG_ALLOC_ALGORITHM,\
					XMG_ALLOC_PROC,\
					XMG_REALLOC_PROC,\
					XMG_FREE_PROC,\
					"xmg_vec",\
					(statusp))

#define XMG_DICT_NEW(statusp)	dict_new(HASH_BASE,\
					 VEC_BASE,\
					 dict_hash_code_public,\
					 XMG_ALLOC_ALGORITHM,\
					 XMG_ALLOC_PROC,\
					 XMG_REALLOC_PROC,\
					 XMG_FREE_PROC,\
					 "xmg_dict",\
					 (statusp))

#define XMG_ONE_DICT_NEW(statusp)	dict_new(HASH_ONE_BASE,\
						 VEC_BASE,\
						 dict_hash_code_public,\
						 XMG_ALLOC_ALGORITHM,\
						 XMG_ALLOC_PROC,\
						 XMG_REALLOC_PROC,\
						 XMG_FREE_PROC,\
						 "xmg_one_dict",\
						 (statusp))

#define XMG_SMALL_DICT_NEW(statusp)	dict_new(HASH_SMALL_BASE,\
						 VEC_BASE,\
						 dict_hash_code_public,\
						 XMG_ALLOC_ALGORITHM,\
						 XMG_ALLOC_PROC,\
						 XMG_REALLOC_PROC,\
						 XMG_FREE_PROC,\
						 "xmg_small_dict",\
						 (statusp))

#define XMG_ID_NEW(statusp)	id_new(HASH_BASE,\
				       VEC_BASE,\
				       XMG_ALLOC_ALGORITHM,\
				       XMG_ALLOC_PROC,\
				       XMG_REALLOC_PROC,\
				       XMG_FREE_PROC,\
				       "xmg_id_new",\
				       (statusp))

extern t_id			*fancy_id;

#ifdef DEBUG
extern t_mask			xmg_verb_level;

#define VERB_XT_MACRO		(1L<<0)
#define VERB_CVT		(1L<<1)
#define VERB_FANCY		(1L<<2)

# define XMG_VERB(level)	((xmg_verb_level != 0L)?\
				 (level) & xmg_verb_level:FALSE) 

#endif

/* PROTO xmg_i.c */
/* include/XmgFancyI.h */
/* xmg_i.c */
void xmg_debug_init P((void));
#endif
