/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef XMGFANCY_H
#define XMGFANCY_H	1

#include <X11/Composite.h>
#include "a.h"

typedef struct 
{
  char					*action;
  t_dict				*vars;	
} XmgFancyFormCallbackStruct;

typedef struct 
{
  char					*base_href;
  char					*href;
  Boolean				new_window;
} XmgFancyLinkCallbackStruct;

typedef struct 
{
  char					*title;
} XmgFancyTitleCallbackStruct;

typedef enum 
{
  FancyImgTypeAny,
  FancyImgTypePixmap,
  FancyImgTypeXImage
} FancyImgType;

typedef struct 
{
  char					*base_href;
  char					*src;
  FancyImgType				type;
  int					depth;
  XtPointer				ptr;
} XmgFancyImgCallbackStruct;

void					XmgFancyParseBuf(
#if NeedFunctionPrototypes
 Widget,
 char *,
 unsigned  int 
#endif
);

void					XmgFancyReset(
#if NeedFunctionPrototypes
 Widget
#endif
);

#ifndef XtNmargin
#define XtNmargin			"margin"
#endif
#ifndef XtCMargin
#define XtCMargin			"Margin"
#endif
#ifndef XtRInt
#define XtRInt				"Int"
#endif

#ifndef XtNsubEltVecBase
#define XtNsubEltVecBase		"subEltVecBase"
#endif
#ifndef XtCSubEltVecBase
#define XtCSubEltVecBase		"SubEltVecBase"
#endif
#ifndef XtRInt
#define XtRInt				"Int"
#endif

#ifndef XtNargsVecBase
#define XtNargsVecBase			"argsVecBase"
#endif
#ifndef XtCArgsVecBase
#define XtCArgsVecBase			"ArgsVecBase"
#endif
#ifndef XtRInt
#define XtRInt				"Int"
#endif

#ifndef XtNvarsHashBase
#define XtNvarsHashBase			"varsHashBase"
#endif
#ifndef XtCVarsHashBase
#define XtCVarsHashBase			"VarsHashBase"
#endif
#ifndef XtRInt
#define XtRInt				"Int"
#endif

#ifndef XtNvarsVecBase
#define XtNvarsVecBase			"varsVecBase"
#endif
#ifndef XtCVarsVecBase
#define XtCVarsVecBase			"VarsVecBase"
#endif
#ifndef XtRInt
#define XtRInt				"Int"
#endif

#ifndef XtNformCallback
#define XtNformCallback			"formCallback"
#endif
#ifndef XtCFormCallback
#define XtCFormCallback			"FormCallback"
#endif
#ifndef XtRCallback
#define XtRCallback			"Callback"
#endif

#ifndef XtNlinkCallback
#define XtNlinkCallback			"linkCallback"
#endif
#ifndef XtCLinkCallback
#define XtCLinkCallback			"LinkCallback"
#endif
#ifndef XtRCallback
#define XtRCallback			"Callback"
#endif

#ifndef XtNtitleCallback
#define XtNtitleCallback		"titleCallback"
#endif
#ifndef XtCTitleCallback
#define XtCTitleCallback		"TitleCallback"
#endif
#ifndef XtRCallback
#define XtRCallback			"Callback"
#endif

#ifndef XtNimgCallback
#define XtNimgCallback			"imgCallback"
#endif
#ifndef XtCImgCallback
#define XtCImgCallback			"ImgCallback"
#endif
#ifndef XtRCallback
#define XtRCallback			"Callback"
#endif

#ifndef XtNbadHTMLWarnings
#define XtNbadHTMLWarnings		"badHTMLWarnings"
#endif
#ifndef XtCBadHTMLWarnings
#define XtCBadHTMLWarnings		"BadHTMLWarnings"
#endif
#ifndef XtRBoolean
#define XtRBoolean			"Boolean"
#endif

#ifndef XtNdoCutAndPaste
#define XtNdoCutAndPaste		"doCutAndPaste"
#endif
#ifndef XtCDoCutAndPaste
#define XtCDoCutAndPaste		"DoCutAndPaste"
#endif

#ifndef XtNdebugKeepSource
#define XtNdebugKeepSource		"debugKeepSource"
#endif
#ifndef XtCDebugKeepSource
#define XtCDebugKeepSource		"DebugKeepSource"
#endif
#ifndef XtRBoolean
#define XtRBoolean			"Boolean"
#endif

#ifndef XtNdebugDrawRowBorders
#define XtNdebugDrawRowBorders		"debugDrawRowBorders"
#endif
#ifndef XtCDebugDrawRowBorders
#define XtCDebugDrawRowBorders		"DebugDrawRowBorders"
#endif
#ifndef XtRBoolean
#define XtRBoolean			"Boolean"
#endif

#ifndef XtNdebugShowCmds
#define XtNdebugShowCmds		"debugShowCmds"
#endif
#ifndef XtCDebugShowCmds
#define XtCDebugShowCmds		"DebugShowCmds"
#endif
#ifndef XtRBoolean
#define XtRBoolean			"Boolean"
#endif

#ifndef XtNdebugShowComments
#define XtNdebugShowComments		"debugShowComments"
#endif
#ifndef XtCDebugShowComments
#define XtCDebugShowComments		"DebugShowComments"
#endif
#ifndef XtRBoolean
#define XtRBoolean			"Boolean"
#endif

#ifndef XtNforceBorder
#define XtNforceBorder			"forceBorder"
#endif
#ifndef XtCForceBorder
#define XtCForceBorder			"ForceBorder"
#endif
#ifndef XtRDimension
#define XtRDimension			"Dimension"
#endif

#ifndef XtNdebugCellSpacing
#define XtNdebugCellSpacing		"debugCellSpacing"
#endif
#ifndef XtCDebugCellSpacing
#define XtCDebugCellSpacing		"DebugCellSpacing"
#endif
#ifndef XtRDimension
#define XtRDimension			"Dimension"
#endif

#ifndef XtNdebugDrawImgBorders
#define XtNdebugDrawImgBorders		"debugDrawImgBorders"
#endif
#ifndef XtCDebugDrawImgBorders
#define XtCDebugDrawImgBorders		"DebugDrawImgBorders"
#endif
#ifndef XtRBoolean
#define XtRBoolean			"Boolean"
#endif

#ifndef XtNuserData
#define XtNuserData			"userData"
#endif
#ifndef XtCUserData
#define XtCUserData			"UserData"
#endif
#ifndef XtRXTPointer
#define XtRXTPointer			"XTPointer"
#endif

#ifndef XtNbrokenPixmap
#define XtNbrokenPixmap			"brokenPixmap"
#endif
#ifndef XtCBrokenPixmap
#define XtCBrokenPixmap			"BrokenPixmap"
#endif
#ifndef XtRPixmap
#define XtRPixmap			"Pixmap"
#endif

#ifndef XtNbrokenXFS
#define XtNbrokenXFS			"brokenXFS"
#endif
#ifndef XtCBrokenXFS
#define XtCBrokenXFS			"BrokenXFS"
#endif
#ifndef XtRFontStruct
#define XtRFontStruct			"FontStruct"
#endif

#ifndef XtNbrokenPixel
#define XtNbrokenPixel			"brokenPixel"
#endif
#ifndef XtCBrokenPixel
#define XtCBrokenPixel			"BrokenPixel"
#endif
#ifndef XtRPixel
#define XtRPixel			"Pixel"
#endif

#ifndef XtNnormalFontName
#define XtNnormalFontName		"normalFontName"
#endif
#ifndef XtCNormalFontName
#define XtCNormalFontName		"NormalFontName"
#endif
#ifndef XtRString
#define XtRString			"String"
#endif

#ifndef XtNsmallFontName
#define XtNsmallFontName		"smallFontName"
#endif
#ifndef XtCSmallFontName
#define XtCSmallFontName		"SmallFontName"
#endif
#ifndef XtRString
#define XtRString			"String"
#endif

#ifndef XtN_tinyFontName
#define XtN_tinyFontName		"_tinyFontName"
#endif
#ifndef XtC_tinyFontName
#define XtC_tinyFontName		"_tinyFontName"
#endif
#ifndef XtRString
#define XtRString			"String"
#endif

#ifndef XtNitalicFontName
#define XtNitalicFontName		"italicFontName"
#endif
#ifndef XtCItalicFontName
#define XtCItalicFontName		"ItalicFontName"
#endif
#ifndef XtRString
#define XtRString			"String"
#endif

#ifndef XtNboldFontName
#define XtNboldFontName			"boldFontName"
#endif
#ifndef XtCBoldFontName
#define XtCBoldFontName			"BoldFontName"
#endif
#ifndef XtRString
#define XtRString			"String"
#endif

#ifndef XtNheader1FontName
#define XtNheader1FontName		"header1FontName"
#endif
#ifndef XtCHeader1FontName
#define XtCHeader1FontName		"Header1FontName"
#endif
#ifndef XtRString
#define XtRString			"String"
#endif

#ifndef XtNheader2FontName
#define XtNheader2FontName		"header2FontName"
#endif
#ifndef XtCHeader2FontName
#define XtCHeader2FontName		"Header2FontName"
#endif
#ifndef XtRString
#define XtRString			"String"
#endif

#ifndef XtNfixedFontName
#define XtNfixedFontName		"fixedFontName"
#endif
#ifndef XtCFixedFontName
#define XtCFixedFontName		"FixedFontName"
#endif
#ifndef XtRString
#define XtRString			"String"
#endif

#ifndef XtNlinkColorName
#define XtNlinkColorName		"linkColorName"
#endif
#ifndef XtCLinkColorName
#define XtCLinkColorName		"LinkColorName"
#endif
#ifndef XtRString
#define XtRString			"String"
#endif

#ifndef XtNvLinkColorName
#define XtNvLinkColorName		"vLinkColorName"
#endif
#ifndef XtCVLinkColorName
#define XtCVLinkColorName		"VLinkColorName"
#endif
#ifndef XtRString
#define XtRString			"String"
#endif

#ifndef XtNtextColorName
#define XtNtextColorName		"textColorName"
#endif
#ifndef XtCTextColorName
#define XtCTextColorName		"TextColorName"
#endif
#ifndef XtRString
#define XtRString			"String"
#endif

#ifndef XtNfgColorName
#define XtNfgColorName			"fgColorName"
#endif
#ifndef XtCFgColorName
#define XtCFgColorName			"FgColorName"
#endif
#ifndef XtRString
#define XtRString			"String"
#endif

#ifndef XtNbgColorName
#define XtNbgColorName			"bgColorName"
#endif
#ifndef XtCBgColorName
#define XtCBgColorName			"BgColorName"
#endif
#ifndef XtRString
#define XtRString			"String"
#endif

typedef struct _XmgFancyClassRec	*XmgFancyWidgetClass;
typedef struct _XmgFancyRec		*XmgFancyWidget;
externalref WidgetClass			xmgFancyWidgetClass;

#endif
