/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include "Xws.h"

#define NS_VERSION      "_MOZILLA_VERSION"
#define NS_COMMAND      "_MOZILLA_COMMAND"
#define NETSCAPE        "Netscape"

/* looks for a netscape window.
   This procedure is used by XwsFindNetscapeWindow(3).
   It checks for the window class or the name provided. It also try to
   find if the window has NS_VERSION property. 
   Returns the window or None */
Window 
XwsNetscapeWindow(display,window,name)
Display *display;
Window window;		/* Window to check */
char *name;		/* Name of window */
{
  Atom type;
  int format;
  int status;
  unsigned long nitems, bytesafter;
  unsigned char **version=NULL;
  Window found=(Window)None;
  XClassHint *classhint;
  
  if (!name)
    {
      if ((XGetWindowProperty(display,
                              window,
                              XInternAtom(display,
					  NS_VERSION,
					  False),
                              0L,
                              (long)BUFSIZ,
                              False,
                              XA_STRING,
                              &type,
                              &format,
                              &nitems,
                              &bytesafter,
                              (unsigned char **)&version)) == Success)
	{
	  if (version && type != None)
	    {
	      found = window;
	      XFree((char *)version);
	    }
	}
    }
  else
    {
      classhint = XAllocClassHint();
      if ((XGetClassHint(display, window, classhint)))
	{
	  if (!strcmp(classhint->res_class, NETSCAPE) &&
	      !strcmp(classhint->res_name, name)) 
	    found = window;
	}
      XFree((char *)classhint);
    }
  return (found);
}

/* find a netscape window.
   It starts from starting_window.
   It uses by example XwsNetscapeWindow(3) as compare_func.
   Returns the Window or None. */
Window
XwsFindNetscapeWindow(display,starting_window,name,compare_func)
Display *display;
Window starting_window;
char *name;
Window (*compare_func)();
{
   Window rootwindow, window_parent;
   int i;
   unsigned int num_children=0;
   Window *children=NULL;
   Window window = (compare_func) (display, starting_window, name);

   if (window != (Window)None) 
     return (window);
   if ((XQueryTree(display,
                   starting_window,
                   &rootwindow,
                   &window_parent,
                   &children,
                   &num_children)) == 0)
     return ((Window)None);
   i = 0;
   while (( i < num_children ) && ( window == (Window)None ))
     window = 
       XwsFindNetscapeWindow(display,
			     children[i++],
			     name,
			     compare_func);
   if (children) 
     XFree((char *)children);
   return(window);
}

/* sends a command to a netscape window. */
void
XwsSendNavigatorCommand(display,window,command)
Display *display;
Window window;
char *command;		/* E.g "OpenURL()" */
{
  XChangeProperty(display,
		  window,
		  XInternAtom(display, NS_COMMAND, False),
		  XA_STRING,
		  8,
		  PropModeReplace,
		  (unsigned char *)command,
		  strlen(command)+1);
  XFlush(display);
}  
