/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include "SmeBSBM.h"
#include "xt_macro.h"
#include "XmgPulldown.h"

VOID_FUNC			XmgPulldownMenuCallback(w,pulldown,cbs)
Widget				w;
Widget				pulldown;
XtPointer			cbs;
{
  char				*label;

  XtVaGetValues(w,
		XtNlabel,	&label,
		NULL);
  XtVaSetValues(pulldown,
                XtNlabel,	label,
                NULL);
}

/* creates a pulldown menu from a vector of strings */
Widget				XmgCreatePulldownFromVecStr(parent,
							    vec_str,
							    proc)
Widget				parent;
t_vec				*vec_str;
XtCallbackProc			proc;
{
  Widget			pulldown;
  char				*label;
  int				textwidth;

  label = "";
  textwidth = 0;
  VEC_FOR(vec_str,char *str)
    {
      int			len;

      len = strlen(str);
      if (len > textwidth)
        {
          textwidth = len;
          label = str;
        }
    }
  VEC_ENDFOR;
  INTERFACE(parent,
            GETCHILD(pulldown)
            (label,menuButtonWidgetClass,
             INSERTCODE(
                        if (VEC_COUNT(vec_str) >= 1)
			{
			  INTERFACE(GETPARENT,
				    CHILDSHELL("menu",simpleMenuWidgetClass,
					       INSERTCODE(
							  VEC_FOR(vec_str,char *str)
							  {
							    INTERFACE(GETPARENT,
								      CHILD("smeBSB",smeBSBObjectClass,
									    XtNlabel,	str,
									    CALLBACK(XtNcallback,(XtCallbackProc)proc,pulldown),
									    END),
								      ENDINTERFACE);
							  }
							    VEC_ENDFOR;
							  ),
					       END),
				    ENDINTERFACE);
			}
			),
	     END),
            ENDINTERFACE);
  return (pulldown);
}

/* creates a complex (subdivised) pulldown menu from a vector of strings */
Widget				XmgCreateComplexPulldownFromVecStr(parent,
								   vec_str,
								   proc)
Widget				parent;
t_vec				*vec_str;
XtCallbackProc			proc;
{
  Widget			pulldown;
  char				*label;
  int				textwidth;
  Widget			menu;
  int				submenu_id;

  submenu_id = 0;
  label = "";
  textwidth = 0;
  VEC_FOR(vec_str,char *str)
    {
      int			len;

      len = strlen(str);
      if (len > textwidth)
        {
          textwidth = len;
          label = str;
        }
    }
  VEC_ENDFOR;
  INTERFACE(parent,
            GETCHILD(pulldown)
            (label,menuButtonWidgetClass,
             INSERTCODE(
                        if (VEC_COUNT(vec_str) >= 1)
			{
			  INTERFACE(pulldown,
				    GETCHILDSHELL(menu)
				    ("menu",simpleMenuWidgetClass,
				     XtNtranslations,
				     XtParseTranslationTable(
"<EnterWindow>:     XmgPopdownAllMenusAfterMe() highlight()  \n\
<LeaveWindow>:     unhighlight()           \n\
<BtnMotion>:       highlight()             \n\
<BtnUp>:           XmgPopdownAllMenus() notify() unhighlight()\n"),
				     INSERTCODE(
						VEC_FOR(vec_str,char *str)
						{
						  Dimension	height;
						  
						  INTERFACE(menu,
							    CHILD("smeBSB",smeBSBObjectClass,
								  XtNlabel,	str,
								  CALLBACK(XtNcallback,(XtCallbackProc)proc,pulldown),
								  END),
							    ENDINTERFACE);
						  XtRealizeWidget(menu);
						  XtVaGetValues(menu,
								XtNheight,	&height,
								NULL);
						  if ((height + 100) > DisplayHeight(XtDisplay(menu),
										     DefaultScreen(XtDisplay(menu))))
						    {
						      char	submenu_name[STR_BUFSIZ];
						      t_status	status;
						      
						      submenu_name[0] = 0;
						      status = ulong_to_str((unsigned long)submenu_id++,
									    10,
									    submenu_name,
									    sizeof (submenu_name));
						      assert(status == 0);
						      INTERFACE(menu,
								CHILD("more...",smeBSBMObjectClass,
								      XtNmenuName,submenu_name,
								      END),
								ENDINTERFACE);
						      INTERFACE(pulldown,
								GETCHILDSHELL(menu)
								(submenu_name,simpleMenuWidgetClass,
								 XtNtranslations,
								 XtParseTranslationTable(
"<EnterWindow>:     XmgPopdownAllMenusAfterMe() highlight()  \n\
<LeaveWindow>:     unhighlight()           \n\
<BtnMotion>:       highlight()             \n\
<BtnUp>:           notify() unhighlight()\n"),
								 END),
								ENDINTERFACE);
						    }
						}
						  VEC_ENDFOR;
						),
				     END),
				    ENDINTERFACE);
			}
			),
	     END),
            ENDINTERFACE);
  return (pulldown);
}

/* create a pulldown menu from a vector of strings (used by XmgFancyWidget). 
   This is used by XmgFancyWidget to fix background color and font */
Widget				XmgFancyCreatePulldownFromVecStr(parent,
								 vec_str,
								 proc,
								 font,
								 bgcolor)
Widget				parent;
t_vec				*vec_str;
XtCallbackProc			proc;
XFontStruct			*font;
Pixel				bgcolor;
{
  Widget			pulldown;
  char				*label;
  int				textwidth;

  label = "";
  textwidth = 0;
  VEC_FOR(vec_str,char *str)
    {
      int			len;

      len = strlen(str);
      if (len > textwidth)
        {
          textwidth = len;
          label = str;
        }
    }
  VEC_ENDFOR;
  INTERFACE(parent,
            GETCHILD(pulldown)
            (label,menuButtonWidgetClass,
	     XtNmappedWhenManaged,	False,
	     XtNfont,			font,
	     XtNbackground,		bgcolor,
             INSERTCODE(
                        if (VEC_COUNT(vec_str) >= 1)
                        INTERFACE(GETPARENT,
                                  CHILDSHELL("menu",simpleMenuWidgetClass,
					     XtNfont,		font,
					     XtNbackground,	bgcolor,
                                             INSERTCODE(
							VEC_FOR(vec_str,char *str)
							{
							  INTERFACE(GETPARENT,
								    CHILD("smeBSB",smeBSBObjectClass,
									  XtNlabel,		str,
									  XtNfont,		font,
									  XtNbackground,	bgcolor,
									  CALLBACK(XtNcallback,(XtCallbackProc)proc,pulldown),
									  END),
                                                                    ENDINTERFACE);
                                                        }
                                                        VEC_ENDFOR;
                                                        ),
                                             END),
                                  ENDINTERFACE);
                        ),
             END),
            ENDINTERFACE);
  return (pulldown);
}
