/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Viewport.h>
#include "xt_macro.h"
#include "XmgPulldown.h"
#include "XmgPrompt.h"

extern Widget			toplevel;

/* shows an autonomous prompt box. */
VOID_FUNC			XmgShowPromptBox(parent,
						 labelstr,
						 valuestr,
						 ok_proc,
						 cancel_proc,
						 data,
						 grab_kind)
Widget				parent;
char				*labelstr;	/* Label string */
char				*valuestr;	/* Value string */
XmgMCallbackProc		ok_proc;	/* Ok proc */
XmgMCallbackProc		cancel_proc;	/* Cancel proc */
XtPointer			data;		/* Data passed to callbacks */
XtGrabKind			grab_kind;	/* Grab kind */
{
  Widget			shell;
  Widget			label;
  Widget			text;
  Widget			ok;
  Widget			cancel;
  XFontStruct			*xfs;
  
  INTERFACE(parent,
            GETCHILDSHELL(shell)
            ("xmgPromptBox",transientShellWidgetClass,
             XtNmappedWhenManaged,	False,
	     XtNtransientFor,		parent,
	     XtNallowShellResize,	True,
	     CHILD("form",formWidgetClass,
                   GETCHILD(label)
                   ("label",labelWidgetClass,
		    XtNlabel,		labelstr,
		    END),
		   GETCHILD(text)
		   ("text",asciiTextWidgetClass,
		    XtNeditType,	XawtextEdit,
		    XtNwrap,		XawtextWrapNever,
		    XtNfromHoriz,	label,
		    XtNstring,		valuestr,
		    XtNresize,		XawtextResizeWidth,
		    XtNresizable,	True,
		    END),
                   GETCHILD(ok)
		   ("okCommand",commandWidgetClass,
		    XtNfromVert,	label,
		    MCALLBACK(XtNcallback,ok_proc,shell,text,data,DONE),
		    END),
		   GETCHILD(cancel)
		   ("cancelCommand",commandWidgetClass,
		    XtNfromHoriz,	ok,
		    XtNfromVert,	text,
		    MCALLBACK(XtNcallback,cancel_proc,shell,data,DONE),
		    END),
                   END),
             MANAGE,
             END),
            ENDINTERFACE);
  XtVaGetValues(text,
		XtNfont,	&xfs,
		NULL);
  XtVaSetValues(text,
		XtNwidth,
		XTextWidth(xfs,valuestr,strlen(valuestr)) + 
		XTextWidth(xfs," ",1),
		NULL);
  XmgCenterWidget(shell);
  XmgSetNopOnReturn(text);
  XmgSetDestroyOnDelete(shell);
  XtPopup(shell,grab_kind);
}

/* shows an autonomous prompt box with a pulldown instead of a text field */
VOID_FUNC		XmgShowPromptPulldownBox(parent,
						 labelstr,
						 values_vec_str,
						 valuestr,
						 ok_proc,
						 cancel_proc,
						 data,
						 grab_kind)
Widget			parent;
char			*labelstr;		/* Label string */
t_vec			*values_vec_str;	/* Vector of strings */
char			*valuestr;		/* Default value */
XmgMCallbackProc	ok_proc;		/* Ok proc */
XmgMCallbackProc	cancel_proc;		/* Cancel proc */
XtPointer		data;			/* Data passed to callbacks */
XtGrabKind		grab_kind;		/* Grab kind */
{
  Widget		shell;
  Widget		label;
  Widget		pulldown;
  Widget		ok;
  Widget		cancel;
  
  INTERFACE(parent,
            GETCHILDSHELL(shell)
            ("xmgPromptBox",transientShellWidgetClass,
             XtNmappedWhenManaged,	False,
	     XtNtransientFor,		parent,
	     XtNallowShellResize,	True,
	     CHILD("form",formWidgetClass,
                   GETCHILD(label)
                   ("label",labelWidgetClass,
		    XtNlabel,		labelstr,
		    END),
		   INSERTCODE(
			      pulldown =
			      XmgCreatePulldownFromVecStr(GETPARENT,
							  values_vec_str,
							  (XtCallbackProc)XmgPulldownMenuCallback);
			      XtVaSetValues(pulldown,
					    XtNlabel,		valuestr,
					    XtNfromHoriz,	label,
					    XtNresizable,	True,
					    NULL);
			      ),
                   GETCHILD(ok)
		   ("okCommand",commandWidgetClass,
		    XtNfromVert,	label,
		    MCALLBACK(XtNcallback,ok_proc,shell,pulldown,data,DONE),
		    END),
		   GETCHILD(cancel)
		   ("cancelCommand",commandWidgetClass,
		    XtNfromHoriz,	ok,
		    XtNfromVert,	pulldown,
		    MCALLBACK(XtNcallback,cancel_proc,shell,data,DONE),
		    END),
                   END),
             MANAGE,
             END),
            ENDINTERFACE);
  XmgCenterWidget(shell);
  XmgSetDestroyOnDelete(shell);
  XtPopup(shell,grab_kind);
}

/* shows an autonomous prompt box with a complex pulldown */
VOID_FUNC		XmgShowPromptComplexPulldownBox(parent,
							labelstr,
							values_vec_str,
							valuestr,
							ok_proc,
							cancel_proc,
							data,
							grab_kind)
Widget			parent;
char			*labelstr;		/* Label string */
t_vec			*values_vec_str;	/* Vector of strings */
char			*valuestr;		/* Default value */
XmgMCallbackProc	ok_proc;		/* Ok proc */
XmgMCallbackProc	cancel_proc;		/* Cancel proc */
XtPointer		data;			/* Data passed to callbacks */
XtGrabKind		grab_kind;		/* Grab kind */
{
  Widget		shell;
  Widget		label;
  Widget		pulldown;
  Widget		ok;
  Widget		cancel;
  
  INTERFACE(parent,
            GETCHILDSHELL(shell)
            ("xmgPromptBox",transientShellWidgetClass,
             XtNmappedWhenManaged,	False,
	     XtNtransientFor,		parent,
	     XtNallowShellResize,	True,
	     CHILD("form",formWidgetClass,
                   GETCHILD(label)
                   ("label",labelWidgetClass,
		    XtNlabel,		labelstr,
		    END),
		   INSERTCODE(
			      pulldown =
			      XmgCreateComplexPulldownFromVecStr(GETPARENT,
							  values_vec_str,
							  (XtCallbackProc)XmgPulldownMenuCallback);
			      XtVaSetValues(pulldown,
					    XtNlabel,		valuestr,
					    XtNfromHoriz,	label,
					    XtNresizable,	True,
					    NULL);
			      ),
                   GETCHILD(ok)
		   ("okCommand",commandWidgetClass,
		    XtNfromVert,	label,
		    MCALLBACK(XtNcallback,ok_proc,shell,pulldown,data,DONE),
		    END),
		   GETCHILD(cancel)
		   ("cancelCommand",commandWidgetClass,
		    XtNfromHoriz,	ok,
		    XtNfromVert,	pulldown,
		    MCALLBACK(XtNcallback,cancel_proc,shell,data,DONE),
		    END),
                   END),
             MANAGE,
             END),
            ENDINTERFACE);
  XmgCenterWidget(shell);
  XmgSetDestroyOnDelete(shell);
  XtPopup(shell,grab_kind);
}
