/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Viewport.h>
#include "xt_macro.h"
#include "XmgPrompt.h"

extern Widget	toplevel;

VOID_FUNC	XmgMessageBoxCallback(w,shell,p)
Widget		w;
Widget		shell;
XtPointer	p;
{
  XtDestroyWidget(shell);
}

/* shows an autonmous message box. 
   It also creates a ok command widget to discard the message */
VOID_FUNC	XmgShowMessageBox(parent,str)
Widget		parent;
char		*str;		/* The string to display */
{
  Widget	shell;
  Widget	label;

  INTERFACE(parent,
            GETCHILDSHELL(shell)
            ("xmgMessageBox",transientShellWidgetClass,
             XtNmappedWhenManaged,	False,
	     CHILD("form",formWidgetClass,
                   GETCHILD(label)
                   ("label",labelWidgetClass,
                    XtNlabel,		str,
                    END),
                   CHILD("Ok",commandWidgetClass,
                         XtNfromHoriz,	label,
                         CALLBACK(XtNcallback,
				  XmgMessageBoxCallback,
				  shell),
                         END),
                   END),
             MANAGE,
             END),
            ENDINTERFACE);
  XmgCenterWidget(shell);
  XmgSetDestroyOnDelete(shell);
  XtPopup(shell,XtGrabNone);
}

/* varargs version of XmgShowMessageBox(3) */
#ifdef HAVE_STDARG_H
VOID_FUNC	XmgShowMessageBoxFmtVa(Widget parent,char *fmt,...)
#else
VOID_FUNC	XmgShowMessageBoxFmtVa(parent,fmt,va_alist)
Widget		parent;
char		*fmt;
va_dcl
#endif
{
  va_list	ap;
  char		buf[BUFSIZ];
  
  assert(fmt);
#ifdef HAVE_STDARG_H
  va_start(ap,fmt);
#else
  va_start(ap);
  va_arg(ap,Widget);
  va_arg(ap,char *);
#endif
  vsnprintf(buf,sizeof (buf),fmt,ap);
  XmgShowMessageBox(parent,buf);
  va_end(ap);
}
